/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.reactive.rxjava2.RxInstrumenterFactory;
import io.micronaut.scheduling.instrument.Instrumentation;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
class RxInstrumentedSubscriber<T>
implements Subscriber<T>,
RxInstrumentedComponent {
    private final Subscriber<T> source;
    private final InvocationInstrumenter instrumenter;

    RxInstrumentedSubscriber(Subscriber<T> source, RxInstrumenterFactory instrumenterFactory) {
        this.source = source;
        this.instrumenter = instrumenterFactory.create();
    }

    @Override
    public void onSubscribe(Subscription s) {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.onSubscribe(s);
        }
    }

    @Override
    public void onNext(T t) {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.onNext(t);
        }
    }

    @Override
    public void onError(Throwable t) {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.onError(t);
        }
    }

    @Override
    public void onComplete() {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.onComplete();
        }
    }
}

