/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.routes.rules;

import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.validation.InternalUriMatchTemplate;
import io.micronaut.validation.InternalUriMatchVariable;
import io.micronaut.validation.routes.RouteValidationResult;
import io.micronaut.validation.routes.rules.RouteValidationRule;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class NullableParameterRule
implements RouteValidationRule {
    @Override
    public RouteValidationResult validate(List<InternalUriMatchTemplate> templates, ParameterElement[] parameters, MethodElement method) {
        ArrayList errorMessages = new ArrayList();
        boolean isClient = method.hasAnnotation("io.micronaut.http.client.annotation.Client");
        if (!isClient) {
            HashMap<String, InternalUriMatchVariable> variables = new HashMap<String, InternalUriMatchVariable>();
            HashSet<InternalUriMatchVariable> required = new HashSet<InternalUriMatchVariable>();
            for (InternalUriMatchTemplate template : templates) {
                for (InternalUriMatchVariable variable : template.getVariables()) {
                    if (!variable.isOptional() || variable.isExploded()) {
                        required.add(variable);
                    }
                    variables.compute(variable.getName(), (key, var) -> {
                        if (var == null) {
                            if (variable.isOptional() && !variable.isExploded()) {
                                return variable;
                            }
                            return null;
                        }
                        if (!var.isOptional() || var.isExploded()) {
                            if (variable.isOptional() && !variable.isExploded()) {
                                return variable;
                            }
                            return var;
                        }
                        return var;
                    });
                }
            }
            for (InternalUriMatchVariable variable : required) {
                if (!templates.stream().anyMatch(t -> !t.getVariableNames().contains(variable.getName()))) continue;
                variables.putIfAbsent(variable.getName(), variable);
            }
            for (InternalUriMatchVariable variable : variables.values()) {
                Arrays.stream(parameters).flatMap(p -> this.getTypedElements((ParameterElement)p).stream()).filter(p -> p.getName().equals(variable.getName())).forEach(p -> {
                    ClassElement type = p.getType();
                    boolean hasDefaultValue = p.findAnnotation(Bindable.class).flatMap(av -> av.stringValue("defaultValue")).isPresent();
                    if (!(this.isNullable((TypedElement)p) || type == null || type.isAssignable(Optional.class) || hasDefaultValue)) {
                        errorMessages.add(String.format("The uri variable [%s] is optional, but the corresponding method argument [%s %s] is not defined as an Optional or annotated with the javax.annotation.Nullable annotation.", variable.getName(), p.getType().toString(), p.getName()));
                    }
                });
            }
        }
        return new RouteValidationResult(errorMessages.toArray(new String[0]));
    }

    private boolean isNullable(TypedElement p) {
        return p.getAnnotationNames().stream().anyMatch(n -> NameUtils.getSimpleName(n).equals("Nullable"));
    }

    private List<TypedElement> getTypedElements(ParameterElement parameterElement) {
        if (parameterElement.hasAnnotation("io.micronaut.http.annotation.RequestBean")) {
            return parameterElement.getType().getBeanProperties().stream().filter(p -> p.hasStereotype((Class<? extends Annotation>)Bindable.class)).collect(Collectors.toList());
        }
        return Collections.singletonList(parameterElement);
    }
}

