/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.websocket;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.validation.InternalUriMatchTemplate;
import io.micronaut.websocket.annotation.WebSocketComponent;
import io.micronaut.websocket.annotation.WebSocketMapping;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.SupportedOptions;

@SupportedOptions(value={"micronaut.websocket.validation"})
public class WebSocketVisitor
implements TypeElementVisitor<WebSocketComponent, WebSocketMapping> {
    static final String VALIDATION_OPTION = "micronaut.websocket.validation";
    private static final String WEB_SOCKET_COMPONENT = "io.micronaut.websocket.annotation.WebSocketComponent";
    private static final String WEB_SOCKET_SESSION = "io.micronaut.websocket.WebSocketSession";
    private static final String HTTP_REQUEST = "io.micronaut.http.HttpRequest";
    private static final String CLOSE_REASON = "io.micronaut.websocket.CloseReason";
    private static final String ON_OPEN = "io.micronaut.websocket.annotation.OnOpen";
    private static final String ON_CLOSE = "io.micronaut.websocket.annotation.OnClose";
    private static final String ON_MESSAGE = "io.micronaut.websocket.annotation.OnMessage";
    private static final String ON_ERROR = "io.micronaut.websocket.annotation.OnError";
    private Map<String, InternalUriMatchTemplate> uriCache = new HashMap<String, InternalUriMatchTemplate>(3);
    private boolean skipValidation = false;

    @Override
    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    @Override
    public Set<String> getSupportedAnnotationNames() {
        return CollectionUtils.setOf(WebSocketComponent.class.getName());
    }

    @Override
    public void visitMethod(MethodElement element, VisitorContext context) {
        if (this.skipValidation) {
            return;
        }
        String uri = element.stringValue(WEB_SOCKET_COMPONENT).orElse("/ws");
        InternalUriMatchTemplate template = this.uriCache.computeIfAbsent(uri, InternalUriMatchTemplate::of);
        List<String> variables = template.getVariableNames();
        Object[] parameters = element.getParameters();
        if (ArrayUtils.isNotEmpty(parameters)) {
            if (element.hasAnnotation(ON_OPEN)) {
                for (Object parameter : parameters) {
                    if (!this.isInvalidParameter(variables, (ParameterElement)parameter, WEB_SOCKET_SESSION, HTTP_REQUEST)) continue;
                    context.fail("Parameter to @OnOpen must either be a URI variable, a WebSocketSession , the HttpRequest, or annotated with an HTTP binding annotation (such as @Header)", (Element)parameter);
                    break;
                }
            } else if (element.hasAnnotation(ON_CLOSE)) {
                for (Object parameter : parameters) {
                    if (!this.isInvalidParameter(variables, (ParameterElement)parameter, WEB_SOCKET_SESSION, CLOSE_REASON)) continue;
                    context.fail("Parameter to @OnClose must either be a URI variable, a CloseReason, a WebSocketSession or annotated with an HTTP binding annotation (such as @Header)", (Element)parameter);
                    break;
                }
            } else if (element.hasAnnotation(ON_ERROR)) {
                for (Object parameter : parameters) {
                    if (!this.isInvalidParameter(variables, (ParameterElement)parameter, WEB_SOCKET_SESSION, Throwable.class.getName())) continue;
                    context.fail("Parameter to @OnError must either be a URI variable, a Throwable, a WebSocketSession or annotated with an HTTP binding annotation (such as @Header)", (Element)parameter);
                    break;
                }
            } else if (element.hasAnnotation(ON_MESSAGE)) {
                ArrayList<Object> bodyParameters = new ArrayList<Object>(3);
                for (Object parameter : parameters) {
                    if (!this.isInvalidParameter(variables, (ParameterElement)parameter, WEB_SOCKET_SESSION)) continue;
                    bodyParameters.add(parameter);
                }
                if (bodyParameters.size() > 1) {
                    context.fail("WebSocket @OnMessage handler has multiple possible message body arguments. : " + bodyParameters, element);
                }
            }
        }
    }

    @Override
    public void start(VisitorContext visitorContext) {
        String prop = visitorContext.getOptions().getOrDefault(VALIDATION_OPTION, "true");
        this.skipValidation = prop != null && prop.equals("false");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInvalidParameter(List<String> variables, ParameterElement parameter, String ... validTypes) {
        String parameterName = parameter.getName();
        ClassElement parameterType = parameter.getType();
        if (parameter.hasStereotype((Class<? extends Annotation>)Bindable.class)) return false;
        if (variables.contains(parameterName)) return false;
        if (!Arrays.stream(validTypes).noneMatch(parameterType::isAssignable)) return false;
        return true;
    }
}

