/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataResolver;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.AntPathMatcher;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.PathMatcher;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.Toggleable;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.web.router.FilterRoute;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

class DefaultFilterRoute
implements FilterRoute {
    private final List<String> patterns = new ArrayList<String>(1);
    private final Supplier<HttpFilter> filterSupplier;
    private final AnnotationMetadataResolver annotationMetadataResolver;
    private Set<HttpMethod> httpMethods;
    private HttpFilter filter;
    private AnnotationMetadata annotationMetadata;

    DefaultFilterRoute(String pattern, Supplier<HttpFilter> filter, AnnotationMetadataResolver annotationMetadataResolver) {
        Objects.requireNonNull(pattern, "Pattern argument is required");
        Objects.requireNonNull(pattern, "HttpFilter argument is required");
        this.filterSupplier = filter;
        this.patterns.add(pattern);
        this.annotationMetadataResolver = annotationMetadataResolver;
    }

    DefaultFilterRoute(String pattern, Supplier<HttpFilter> filter) {
        this(pattern, filter, AnnotationMetadataResolver.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public AnnotationMetadata getAnnotationMetadata() {
        AnnotationMetadata annotationMetadata = this.annotationMetadata;
        if (annotationMetadata == null) {
            DefaultFilterRoute defaultFilterRoute = this;
            synchronized (defaultFilterRoute) {
                annotationMetadata = this.annotationMetadata;
                if (annotationMetadata == null) {
                    this.annotationMetadata = annotationMetadata = this.annotationMetadataResolver.resolveMetadata(this.getFilter());
                }
            }
        }
        return annotationMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpFilter getFilter() {
        HttpFilter filter = this.filter;
        if (filter == null) {
            DefaultFilterRoute defaultFilterRoute = this;
            synchronized (defaultFilterRoute) {
                filter = this.filter;
                if (filter == null) {
                    this.filter = filter = this.filterSupplier.get();
                }
            }
        }
        return filter;
    }

    @Override
    @NonNull
    public Set<HttpMethod> getFilterMethods() {
        return this.httpMethods;
    }

    @Override
    @NonNull
    public String[] getPatterns() {
        return this.patterns.toArray(StringUtils.EMPTY_STRING_ARRAY);
    }

    @Override
    public Optional<HttpFilter> match(HttpMethod method, URI uri) {
        if (this.httpMethods != null && !this.httpMethods.contains(method)) {
            return Optional.empty();
        }
        String uriStr = uri.getPath();
        AntPathMatcher matcher = PathMatcher.ANT;
        for (String pattern : this.patterns) {
            if (!matcher.matches(pattern, uriStr)) continue;
            HttpFilter filter = this.getFilter();
            if (filter instanceof Toggleable && !((Toggleable)((Object)filter)).isEnabled()) {
                return Optional.empty();
            }
            return Optional.of(filter);
        }
        return Optional.empty();
    }

    @Override
    public FilterRoute pattern(String pattern) {
        if (StringUtils.isNotEmpty(pattern)) {
            this.patterns.add(pattern);
        }
        return this;
    }

    @Override
    public FilterRoute methods(HttpMethod ... methods) {
        if (ArrayUtils.isNotEmpty(methods)) {
            if (this.httpMethods == null) {
                this.httpMethods = new HashSet<HttpMethod>();
            }
            this.httpMethods.addAll(Arrays.asList(methods));
        }
        return this;
    }
}

