/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.uri.UriMatchInfo;
import io.micronaut.http.uri.UriMatchVariable;
import io.micronaut.web.router.AbstractRouteMatch;
import io.micronaut.web.router.DefaultRouteBuilder;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.UriRoute;
import io.micronaut.web.router.UriRouteMatch;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@Internal
class DefaultUriRouteMatch<T, R>
extends AbstractRouteMatch<T, R>
implements UriRouteMatch<T, R> {
    private final HttpMethod httpMethod;
    private final UriMatchInfo matchInfo;
    private final DefaultRouteBuilder.DefaultUriRoute uriRoute;
    private final Charset defaultCharset;

    DefaultUriRouteMatch(UriMatchInfo matchInfo, DefaultRouteBuilder.DefaultUriRoute uriRoute, Charset defaultCharset, ConversionService<?> conversionService) {
        super(uriRoute, conversionService);
        this.uriRoute = uriRoute;
        this.matchInfo = matchInfo;
        this.httpMethod = uriRoute.httpMethod;
        this.defaultCharset = defaultCharset;
    }

    @Override
    public UriRouteMatch<T, R> decorate(Function<RouteMatch<R>, R> executor) {
        Map<String, Object> variables = this.getVariableValues();
        Collection arguments = this.getRequiredArguments();
        DefaultUriRouteMatch thisRoute = this;
        return new DefaultUriRouteMatch<T, R>(this.matchInfo, this.uriRoute, this.defaultCharset, this.conversionService, (List)arguments, executor, thisRoute, variables){
            final /* synthetic */ List val$arguments;
            final /* synthetic */ Function val$executor;
            final /* synthetic */ RouteMatch val$thisRoute;
            final /* synthetic */ Map val$variables;
            {
                this.val$arguments = list;
                this.val$executor = function;
                this.val$thisRoute = routeMatch;
                this.val$variables = map;
                super(matchInfo, uriRoute, defaultCharset, conversionService);
            }

            @Override
            public List<Argument> getRequiredArguments() {
                return this.val$arguments;
            }

            @Override
            public R execute(Map argumentValues) {
                return this.val$executor.apply(this.val$thisRoute);
            }

            @Override
            public Map<String, Object> getVariableValues() {
                return this.val$variables;
            }
        };
    }

    @Override
    protected RouteMatch<R> newFulfilled(final Map<String, Object> newVariables, final List<Argument> requiredArguments) {
        return new DefaultUriRouteMatch<T, R>(this.matchInfo, this.uriRoute, this.defaultCharset, this.conversionService){

            @Override
            public List<Argument> getRequiredArguments() {
                return requiredArguments;
            }

            @Override
            public Map<String, Object> getVariableValues() {
                return newVariables;
            }
        };
    }

    @Override
    public UriRouteMatch<T, R> fulfill(Map<String, Object> argumentValues) {
        return (UriRouteMatch)super.fulfill(argumentValues);
    }

    @Override
    public String getUri() {
        return this.matchInfo.getUri();
    }

    @Override
    public Map<String, Object> getVariableValues() {
        Map<String, Object> variables = this.matchInfo.getVariableValues();
        if (CollectionUtils.isNotEmpty(variables)) {
            String charset = this.defaultCharset.toString();
            LinkedHashMap<String, Object> decoded = new LinkedHashMap<String, Object>(variables.size());
            variables.forEach((k, v) -> {
                if (v instanceof CharSequence) {
                    try {
                        v = URLDecoder.decode(v.toString(), charset);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                decoded.put((String)k, v);
            });
            return decoded;
        }
        return variables;
    }

    @Override
    public List<UriMatchVariable> getVariables() {
        return this.matchInfo.getVariables();
    }

    @Override
    public Map<String, UriMatchVariable> getVariableMap() {
        return this.matchInfo.getVariableMap();
    }

    @Override
    public UriRoute getRoute() {
        return (UriRoute)((Object)this.abstractRoute);
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String toString() {
        return this.httpMethod + " - " + this.matchInfo.getUri();
    }
}

