/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router.version.resolution;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.web.router.version.RoutesVersioningConfiguration;
import io.micronaut.web.router.version.resolution.HeaderVersionResolverConfiguration;
import io.micronaut.web.router.version.resolution.RequestVersionResolver;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
@Requires(beans={RoutesVersioningConfiguration.class, HeaderVersionResolverConfiguration.class})
public class HeaderVersionResolver
implements RequestVersionResolver {
    private final List<String> headerNames;

    public HeaderVersionResolver(HeaderVersionResolverConfiguration configuration) {
        this.headerNames = configuration.getNames();
    }

    @Override
    public Optional<String> resolve(HttpRequest<?> request) {
        return this.headerNames.stream().map(name -> (String)request.getHeaders().get((CharSequence)name)).filter(Objects::nonNull).findFirst();
    }
}

