/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.canaveral.mock.redis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import pl.codewise.canaveral.core.mock.MockConfig;
import pl.codewise.canaveral.core.mock.MockProvider;
import pl.codewise.canaveral.core.runtime.RunnerContext;
import pl.codewise.canaveral.core.util.PropertyHelper;

public class RedisMockProvider
implements MockProvider {
    private static final Logger log = LoggerFactory.getLogger(RedisMockProvider.class);
    private final RedisMockConfig mockConfig;
    private final String mockName;
    private int port;
    private String host;
    private GenericContainer server;

    private RedisMockProvider(RedisMockConfig mockConfig, String mockName) {
        this.mockConfig = mockConfig;
        this.mockName = mockName;
    }

    public static RedisMockConfig newConfig() {
        return new RedisMockConfig();
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getEndpoint() {
        return "http://" + this.getHost() + ":" + this.getPort();
    }

    public String getMockName() {
        return this.mockName;
    }

    public void start(RunnerContext context) {
        log.info("Starting dockerized Redis from {}.", (Object)this.mockConfig.image);
        this.server = new GenericContainer(this.mockConfig.image).withExposedPorts(new Integer[]{6379}).withStartupTimeout(Duration.ofSeconds(5L));
        this.server.start();
        this.port = this.server.getFirstMappedPort();
        this.host = this.server.getContainerIpAddress();
        PropertyHelper.setProperty((String)this.mockConfig.portProperty, (String)Integer.toString(this.port));
        PropertyHelper.setProperty((String)this.mockConfig.hostProperty, (String)this.getHost());
    }

    public void stop() {
        this.server.stop();
    }

    public RedisMockProvider reset() {
        if (this.server.isRunning()) {
            this.server.stop();
        }
        this.server.start();
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mockName", (Object)this.mockName).toString();
    }

    public static class RedisMockConfig
    implements MockConfig<RedisMockProvider> {
        private String hostProperty;
        private String portProperty;
        private String image;

        private RedisMockConfig() {
        }

        public RedisMockProvider build(String mockName) {
            return new RedisMockProvider(this, mockName);
        }

        public RedisMockConfig registerHostUnder(String key) {
            this.hostProperty = key;
            return this;
        }

        public RedisMockConfig registerPortUnder(String key) {
            this.portProperty = key;
            return this;
        }

        public RedisMockConfig withRedisDockerImage(String image) {
            Preconditions.checkArgument((boolean)image.startsWith("redis:"), (Object)"Redis docker image should be referenced as 'redis:version'.");
            this.image = image;
            return this;
        }
    }
}

