/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.plugin;

import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import pl.decerto.plugin.model.MavenProperties;
import pl.decerto.plugin.service.impl.LiquibaseSnapshotServiceImpl;

@Mojo(name="moveSnapshots", defaultPhase=LifecyclePhase.NONE)
public class LiquibaseSnapshotMojo
extends AbstractMojo {
    @Parameter(defaultValue="/src/main/resources/liquibase/")
    private String liquibaseDir;
    @Parameter(defaultValue="/src/main/resources/liquibase/snapshot/")
    private String liquibaseSnapshotDir;
    @Parameter(defaultValue="${project.version}")
    private String projectVersion;
    @Parameter(defaultValue="${basedir}")
    private String projectBaseDir;
    @Parameter(defaultValue="${finalName}")
    private String artifactName;
    @Parameter(defaultValue="${line.separator}")
    private String lineSeparator;
    @Parameter
    private List<String> changelogFiles;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenProperties mavenProperties = this.buildMavenProperties();
        LiquibaseSnapshotServiceImpl service = new LiquibaseSnapshotServiceImpl(mavenProperties);
        service.moveSnapshots();
    }

    private MavenProperties buildMavenProperties() {
        return MavenProperties.builder().liquibaseDir(this.formatPath(this.liquibaseDir)).liquibaseSnapshotDir(this.formatPath(this.liquibaseSnapshotDir)).projectBaseDir(this.formatPath(this.projectBaseDir)).projectVersion(this.projectVersion).artifactName(this.artifactName).lineSeparator(this.lineSeparator).changelogFiles(this.changelogFiles).logger(this.getLog()).build();
    }

    private String formatPath(String path) {
        return path.replace('\\', '/');
    }
}

