/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.plugin.git.impl;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import pl.decerto.plugin.git.GitService;

public class GitServiceImpl
implements GitService {
    private static final String COMMIT_MESSAGE = "Adding liquibase to version {0}";
    private final String projectVersion;
    private Repository repo;

    public GitServiceImpl(String projectVersion) {
        this.projectVersion = projectVersion;
        this.openRepository();
    }

    @Override
    public void commitDirectory(File commitDir) {
        try {
            this.addFilesFrom(commitDir);
            this.commitWithMessage(this.formatCommitMsg());
        }
        catch (GitAPIException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void addFilesFrom(File commitDir) throws GitAPIException {
        AddCommand addNewFiles = new Git(this.repo).add();
        addNewFiles.addFilepattern(this.getPath(commitDir)).call();
        AddCommand addUpdatedFiles = new Git(this.repo).add();
        addUpdatedFiles.addFilepattern(this.getPath(commitDir)).setUpdate(true).call();
    }

    private void commitWithMessage(String commitMsg) throws GitAPIException {
        CommitCommand git = new Git(this.repo).commit();
        git.setMessage(commitMsg).setInsertChangeId(true).call();
    }

    private void openRepository() {
        try {
            this.repo = ((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir()).build();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String formatCommitMsg() {
        return MessageFormat.format(COMMIT_MESSAGE, this.projectVersion);
    }

    private String getPath(File file) {
        return this.getRelativePath(file).replace('\\', '/');
    }

    private String getRelativePath(File file) {
        return Repository.stripWorkDir((File)this.repo.getWorkTree(), (File)file);
    }
}

