/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.plugin.service.impl;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.logging.Log;
import pl.decerto.plugin.git.GitService;
import pl.decerto.plugin.git.impl.GitServiceImpl;
import pl.decerto.plugin.model.MavenProperties;
import pl.decerto.plugin.service.LiquibaseSnapshotService;

public class LiquibaseSnapshotServiceImpl
implements LiquibaseSnapshotService {
    private final Log logger;
    private final MavenProperties mavenProperties;
    private final GitService gitService;

    public LiquibaseSnapshotServiceImpl(MavenProperties mavenProperties) {
        this.mavenProperties = mavenProperties;
        this.gitService = new GitServiceImpl(mavenProperties.getProjectVersion());
        this.logger = mavenProperties.getLogger();
    }

    @Override
    public void moveSnapshots() {
        if (this.thereAreChanges()) {
            this.processSnapshotFiles();
            this.commitChanges();
        } else {
            this.logger.info((CharSequence)"No snapshots in liquibase directory - skipping");
        }
    }

    private boolean thereAreChanges() {
        File snapshotDir = this.getSnapshotDir();
        return snapshotDir.listFiles() != null && snapshotDir.listFiles().length > 1;
    }

    private void processSnapshotFiles() {
        try {
            this.moveSnapshotFilesToProjectVersionDir();
            this.createEmptyChangeLogFile();
            this.modifyChangelogFiles();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void modifyChangelogFiles() throws IOException {
        for (String changelogFile : this.mavenProperties.getChangelogFiles()) {
            this.modifyChangelogFile(changelogFile);
        }
    }

    private void modifyChangelogFile(String changelogFilename) throws IOException {
        File changelogFile = this.getChangelogFile(changelogFilename);
        this.replaceContentInFile(changelogFile);
    }

    private void replaceContentInFile(File changelogFile) throws IOException {
        this.logger.info((CharSequence)MessageFormat.format("Adding include to {0}", changelogFile.getName()));
        String content = FileUtils.readFileToString((File)changelogFile);
        String modifiedContent = content.replace("<!--placeForVersionInclude-->", this.getFormattedSnapshotChangelogInclude());
        FileUtils.forceDelete((File)changelogFile);
        FileUtils.writeStringToFile((File)changelogFile, (String)modifiedContent);
    }

    private void moveSnapshotFilesToProjectVersionDir() throws IOException {
        this.logger.info((CharSequence)MessageFormat.format("Moving changes to {0} directory", this.mavenProperties.getProjectVersion()));
        File snapshotDir = this.getSnapshotDir();
        File projectVersionDir = this.getProjectVersionDir();
        FileUtils.copyDirectory((File)snapshotDir, (File)projectVersionDir);
        FileUtils.deleteDirectory((File)snapshotDir);
    }

    private void createEmptyChangeLogFile() throws IOException {
        this.logger.info((CharSequence)"Preparing empty version.changelog.xml inside snapshot directory");
        File snapshotDir = this.getSnapshotDir();
        File templateChangeLogFile = this.getChangelogTemplateFile();
        this.copyFileToDestinationFromSource(snapshotDir, templateChangeLogFile);
    }

    private void copyFileToDestinationFromSource(File snapshotDir, File templateChangeLogFile) throws IOException {
        if (!snapshotDir.exists()) {
            snapshotDir.mkdir();
        }
        FileUtils.copyFileToDirectory((File)templateChangeLogFile, (File)snapshotDir);
    }

    private void commitChanges() {
        this.logger.info((CharSequence)"Commiting liquibase directory");
        this.logger.info((CharSequence)this.getLiquibaseDir().getAbsolutePath());
        this.gitService.commitDirectory(this.getLiquibaseDir());
    }

    private File getProjectVersionDir() {
        return new File(this.mavenProperties.getProjectBaseDir() + this.mavenProperties.getLiquibaseDir() + this.mavenProperties.getProjectVersion());
    }

    private File getSnapshotDir() {
        return new File(this.mavenProperties.getProjectBaseDir() + this.mavenProperties.getLiquibaseSnapshotDir());
    }

    private File getChangelogTemplateFile() {
        return new File(this.mavenProperties.getProjectBaseDir() + this.mavenProperties.getLiquibaseDir() + "/template/" + "version.changelog.xml");
    }

    private File getLiquibaseDir() {
        return new File(this.mavenProperties.getProjectBaseDir() + this.mavenProperties.getLiquibaseDir());
    }

    private File getChangelogFile(String changelogFile) {
        return new File(this.mavenProperties.getProjectBaseDir() + this.mavenProperties.getLiquibaseDir() + changelogFile);
    }

    private String getFormattedSnapshotChangelogInclude() {
        return MessageFormat.format("<include file=\"{0}/version.changelog.xml\" relativeToChangelogFile=\"true\" />{1}    <!--placeForVersionInclude-->", this.mavenProperties.getProjectVersion(), this.mavenProperties.getLineSeparator());
    }
}

