/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest;

import com.zaxxer.hikari.HikariDataSource;
import java.util.function.Predicate;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.security.servlet.ManagementWebSecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseAutoConfiguration;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerTypePredicate;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import pl.decerto.hyperon.common.CommonConfiguration;
import pl.decerto.hyperon.rest.configuration.DatabaseProperties;
import pl.decerto.hyperon.rest.configuration.SwaggerConfiguration;
import pl.decerto.hyperon.runtime.core.HyperonEngine;
import pl.decerto.hyperon.runtime.core.HyperonEngineFactory;
import pl.decerto.hyperon.runtime.core.domain.DomainCache;
import pl.decerto.hyperon.runtime.profiler.jdbc.proxy.DataSourceProxy;
import pl.decerto.hyperon.runtime.sql.DialectRegistry;
import pl.decerto.hyperon.runtime.sql.DialectTemplate;

@SpringBootApplication(exclude={LiquibaseAutoConfiguration.class, SecurityAutoConfiguration.class, ManagementWebSecurityAutoConfiguration.class})
@Import(value={SwaggerConfiguration.class, CommonConfiguration.class})
@ImportResource(value={"classpath:hyperon-runtime-rest-security${authType:}.xml", "classpath:hyperon-runtime-rest-jpa.xml"})
public class HyperonRuntimeRestApplication
implements WebMvcConfigurer {
    @Bean
    public DialectRegistry dialectRegistry(DatabaseProperties databaseProperties) {
        DialectRegistry registry = new DialectRegistry();
        registry.setDialect((Object)databaseProperties.getDialect());
        return registry;
    }

    @Bean
    public DialectTemplate dialectTemplate(DialectRegistry dialectRegistry) {
        return dialectRegistry.create();
    }

    @Bean
    @Qualifier(value="dataSource")
    public DataSource dataSourceProxy(@Qualifier(value="_dataSource") DataSource dataSource) {
        return new DataSourceProxy(dataSource);
    }

    @Bean
    @Qualifier(value="_dataSource")
    public DataSource dataSource(DialectTemplate dialectTemplate, DatabaseProperties databaseProperties) {
        HikariDataSource dataSource = new HikariDataSource();
        dataSource.setUsername(databaseProperties.getDbUsername());
        dataSource.setPassword(databaseProperties.getDbPassword());
        dataSource.setJdbcUrl(databaseProperties.getDbUrl());
        dataSource.setDriverClassName(dialectTemplate.getJdbcDriverClassName());
        return dataSource;
    }

    @Bean(destroyMethod="destroy")
    public HyperonEngineFactory hyperonEngineFactory(DataSource dataSource) {
        HyperonEngineFactory hyperonEngineFactory = new HyperonEngineFactory();
        hyperonEngineFactory.setDataSource(dataSource);
        hyperonEngineFactory.setDeveloperMode(true);
        hyperonEngineFactory.setUsername("admin");
        return hyperonEngineFactory;
    }

    @Bean
    public HyperonEngine hyperonEngine(HyperonEngineFactory engineFactory) {
        return engineFactory.create();
    }

    @Bean
    @DependsOn(value={"hyperonEngine"})
    public DomainCache domainCache(HyperonEngineFactory engineFactory) {
        return engineFactory.getDomainCache();
    }

    public static void main(String[] args) {
        SpringApplication.run(HyperonRuntimeRestApplication.class, (String[])args);
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
        configurer.addPathPrefix("/api", (Predicate)HandlerTypePredicate.forAnnotation((Class[])new Class[]{RestController.class}));
    }
}

