/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.domain;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import pl.decerto.hyperon.rest.domain.DomainController;
import pl.decerto.hyperon.rest.domain.DomainService;
import pl.decerto.hyperon.rest.domain.GetAllPathsResponse;

@RestController
@RequestMapping(value={"/domain"})
@Api(value="Domain", tags={"Domain"})
public class DomainControllerSpringImpl
implements DomainController {
    private static final Logger log = LoggerFactory.getLogger(DomainControllerSpringImpl.class);
    private final DomainService domainService;

    @ApiOperation(value="Get all domain paths", notes="Get all available domain paths from given profile")
    @GetMapping(value={"/{profileCode}/paths"})
    public GetAllPathsResponse getAllPaths(@ApiParam(value="profile code from which domain will be taken", required=true) @PathVariable String profileCode) {
        log.debug("getting all domain paths in profile:{}", (Object)profileCode);
        Collection paths = this.domainService.getAll(profileCode);
        log.debug("got {} paths", (Object)paths.size());
        return new GetAllPathsResponse(paths);
    }

    public DomainControllerSpringImpl(DomainService domainService) {
        this.domainService = domainService;
    }
}

