/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import pl.decerto.hyperon.rest.domain.DomainService;
import pl.decerto.hyperon.runtime.core.domain.DomainCache;
import pl.decerto.hyperon.runtime.model.DomainTokenResolver;
import pl.decerto.hyperon.runtime.model.HyperonDomainObject;
import pl.decerto.hyperon.runtime.model.HyperonDomainObjectImpl;

@Service
public class DomainServiceImpl
implements DomainService {
    private static final Logger log = LoggerFactory.getLogger(DomainServiceImpl.class);
    private final DomainCache domainCache;

    public Collection<String> getAll(String profileCode) {
        log.info("getting all paths for profile code:{}", (Object)profileCode);
        List<String> paths = this.getDomain(profileCode, "/").map(root -> this.getAllPaths((HyperonDomainObjectImpl)root)).orElse(Collections.emptyList());
        log.info("found {} paths", (Object)paths.size());
        return paths;
    }

    private List<String> getAllPaths(HyperonDomainObjectImpl root) {
        ArrayList<String> result = new ArrayList<String>();
        this.findAllPaths(root, result, new HashMap());
        return result;
    }

    private void findAllPaths(HyperonDomainObjectImpl parent, List<String> result, Map<Integer, Boolean> visited) {
        if (this.noFurtherActionPossible(parent, visited)) {
            this.logNoFurtherActionCause(parent);
            return;
        }
        this.markElementAsVisited(parent.getId(), visited);
        String path = parent.getPath();
        if (StringUtils.isNotEmpty((CharSequence)parent.getCode())) {
            log.debug("adding path:{}", (Object)path);
            result.add(path);
        }
        for (HyperonDomainObjectImpl child : parent.getChildren()) {
            parent.getReferenceCollectionCode(child.getId()).ifPresent(collectionCode -> this.addReferencePath(result, path, child, collectionCode));
            this.findAllPaths(child, result, visited);
        }
    }

    private void logNoFurtherActionCause(HyperonDomainObjectImpl parent) {
        if (Objects.isNull(parent)) {
            log.trace("no further action possible because of null domain element");
        } else {
            log.trace("no further action possible for element:{}", (Object)parent.getId());
        }
    }

    private void addReferencePath(List<String> result, String path, HyperonDomainObjectImpl child, String collectionCode) {
        log.debug("found reference, id:{}", (Object)child.getId());
        String referencePath = this.createReferencePath(path, child, collectionCode);
        log.debug("adding reference path:{}", (Object)referencePath);
        result.add(referencePath);
    }

    private String createReferencePath(String parentPath, HyperonDomainObjectImpl child, String collectionCode) {
        return this.getParentPathWithSeparator(parentPath) + DomainTokenResolver.resolveFullToken((String)collectionCode, (String)child.getCode());
    }

    private String getParentPathWithSeparator(String parentPath) {
        if (Objects.isNull(parentPath)) {
            return "/";
        }
        return parentPath.endsWith("/") ? parentPath : parentPath + "/";
    }

    private boolean noFurtherActionPossible(HyperonDomainObjectImpl domainObject, Map<Integer, Boolean> visited) {
        return domainObject == null || this.isElementAlreadyVisited(visited, domainObject.getId());
    }

    private boolean isElementAlreadyVisited(Map<Integer, Boolean> visited, Integer elementId) {
        return visited.get(elementId) != null && visited.get(elementId) != false;
    }

    private void markElementAsVisited(Integer elementId, Map<Integer, Boolean> visited) {
        log.trace("marking element:{} as visited", (Object)elementId);
        visited.put(elementId, true);
    }

    private Optional<HyperonDomainObject> getDomain(String profileCode, String objectPath) {
        if (this.domainCache != null) {
            return Optional.ofNullable(this.domainCache.getDomain(profileCode, objectPath));
        }
        return Optional.empty();
    }

    public DomainServiceImpl(DomainCache domainCache) {
        this.domainCache = domainCache;
    }
}

