/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.execution;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.rest.execution.ContextProperty;
import pl.decerto.hyperon.rest.execution.ExecutionData;
import pl.decerto.hyperon.runtime.core.HyperonContext;

@Component
class ContextBuilder {
    ContextBuilder() {
    }

    HyperonContext create(ExecutionData executionData) {
        return this.create(this.getProperties(executionData));
    }

    private HyperonContext create(List<ContextProperty> properties) {
        HyperonContext ctx = new HyperonContext(new Object[0]);
        for (ContextProperty property : properties) {
            if (property.getValue() != null) {
                ctx.set(property.getKey(), (Object)property.getValue());
                continue;
            }
            if (property.getValues() != null) {
                ctx.set(property.getKey(), (Object)property.getValues());
                continue;
            }
            if (property.getComplexValue() != null) {
                ctx.set(property.getKey(), (Object)this.create(property.getComplexValue()));
                continue;
            }
            if (property.getComplexValues() == null) continue;
            ctx.set(property.getKey(), (Object)this.createCollection(property.getComplexValues()));
        }
        return ctx;
    }

    private List<HyperonContext> createCollection(List<List<ContextProperty>> properties) {
        return properties.stream().map(arg_0 -> this.create(arg_0)).collect(Collectors.toList());
    }

    private List<ContextProperty> getProperties(ExecutionData executionData) {
        return executionData.getCtx() == null ? Collections.emptyList() : executionData.getCtx().getProperties();
    }
}

