/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.execution;

import java.util.Date;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.rest.execution.dto.EffectiveVersionConfigurationDto;
import pl.decerto.hyperon.rest.execution.dto.RegionVersionIdentifierDto;
import pl.decerto.hyperon.runtime.core.HyperonEngine;

@Component
class EffectiveVersionManager {
    private static final Logger log = LoggerFactory.getLogger(EffectiveVersionManager.class);
    private final HyperonEngine hyperonEngine;

    void set(@Nullable EffectiveVersionConfigurationDto effectiveVersionConfigurationDto) {
        Set regionVersionIdentifiers;
        log.debug("Set effective version entered with {}", (Object)effectiveVersionConfigurationDto);
        if (Objects.isNull(effectiveVersionConfigurationDto)) {
            log.debug("Effective version configuration is null, skipping");
            return;
        }
        Date effectiveDate = effectiveVersionConfigurationDto.getEffectiveDate();
        if (effectiveDate != null) {
            log.info("Setting effective date to: {}", (Object)effectiveDate);
            this.hyperonEngine.setEffectiveDate(effectiveDate);
        }
        if (Objects.isNull(regionVersionIdentifiers = effectiveVersionConfigurationDto.getRegionVersionIdentifier())) {
            return;
        }
        for (RegionVersionIdentifierDto regionVersionIdentifier : regionVersionIdentifiers) {
            this.setEffectiveVersion(regionVersionIdentifier);
        }
    }

    void clear() {
        this.hyperonEngine.clearEffectiveSetup();
    }

    private void setEffectiveVersion(RegionVersionIdentifierDto regionVersionIdentifier) {
        String profileCode = regionVersionIdentifier.getProfileCode();
        String regionCode = regionVersionIdentifier.getRegionCode();
        String version = regionVersionIdentifier.getVersion();
        if (Objects.isNull(profileCode) && !Objects.isNull(version)) {
            log.info("Setting effective version to regionCode = {}, and version = {}", (Object)regionCode, (Object)version);
            this.hyperonEngine.setEffectiveVersion(regionCode, version);
            return;
        }
        if (!(Objects.isNull(profileCode) || Objects.isNull(regionCode) || Objects.isNull(version))) {
            log.info("Setting effective version to profileCode = {}, regionCode = {}, and version = {}", new Object[]{profileCode, regionCode, version});
            this.hyperonEngine.setEffectiveVersion(profileCode, regionCode, version);
        }
    }

    public EffectiveVersionManager(HyperonEngine hyperonEngine) {
        this.hyperonEngine = hyperonEngine;
    }
}

