/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.execution;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import pl.decerto.hyperon.rest.execution.ArgumentsBuilder;
import pl.decerto.hyperon.rest.execution.ContextBuilder;
import pl.decerto.hyperon.rest.execution.EffectiveVersionManager;
import pl.decerto.hyperon.rest.execution.ExecutionController;
import pl.decerto.hyperon.rest.execution.ExecutionData;
import pl.decerto.hyperon.rest.execution.ExecutionElementIdentifier;
import pl.decerto.hyperon.rest.execution.ExecutionResult;
import pl.decerto.hyperon.rest.execution.ExecutionService;
import pl.decerto.hyperon.runtime.core.HyperonContext;
import pl.decerto.hyperon.runtime.model.MpElementType;

@RestController
@RequestMapping(value={"/execution"})
@Api(value="Execution", tags={"Execution"})
public class ExecutionControllerSpringImpl
implements ExecutionController {
    private static final Logger log = LoggerFactory.getLogger(ExecutionControllerSpringImpl.class);
    private final ExecutionService executionService;
    private final EffectiveVersionManager effectiveVersionManager;
    private final ContextBuilder contextBuilder;
    private final ArgumentsBuilder argumentsBuilder;

    @ApiOperation(value="Execute given parameters/functions/domain object for provided context", notes="returns resolved value from parameters/functions/domain for given context. Parameters and domain objects return ParamValue object, function may return any object, for example String or Integer")
    @PostMapping(value={"/execute"}, produces={"application/json"})
    public List<ExecutionResult> execute(@ApiParam(value="execution data that tells Hyperon what to execute", required=true) @Valid @RequestBody ExecutionData executionData) {
        log.debug("execute called {}", (Object)executionData);
        this.effectiveVersionManager.set(executionData.getEffectiveVersionConfiguration());
        ArrayList<ExecutionResult> result = new ArrayList<ExecutionResult>();
        HyperonContext ctx = this.contextBuilder.create(executionData);
        Object[] arguments = this.argumentsBuilder.create(executionData.getArguments());
        for (ExecutionElementIdentifier element : executionData.getElements()) {
            this.validateElementData(element);
            Object elementExecResult = this.executionService.execute(element, ctx, arguments);
            result.add(new ExecutionResult(element, elementExecResult));
        }
        this.effectiveVersionManager.clear();
        log.debug("execution ended, result:{}", result);
        return result;
    }

    private void validateElementData(ExecutionElementIdentifier element) {
        if (MpElementType.DOMAIN_OBJECT == element.getType()) {
            this.validateDomainData(element);
        }
    }

    private void validateDomainData(ExecutionElementIdentifier domainElement) {
        if (StringUtils.isEmpty((CharSequence)domainElement.getProfileCode()) || StringUtils.isEmpty((CharSequence)domainElement.getAttributeCode())) {
            throw new IllegalArgumentException("profile code and attribute code are necessary for domain execution");
        }
    }

    public ExecutionControllerSpringImpl(ExecutionService executionService, EffectiveVersionManager effectiveVersionManager, ContextBuilder contextBuilder, ArgumentsBuilder argumentsBuilder) {
        this.executionService = executionService;
        this.effectiveVersionManager = effectiveVersionManager;
        this.contextBuilder = contextBuilder;
        this.argumentsBuilder = argumentsBuilder;
    }
}

