/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.execution;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.context.ParamContext;
import org.smartparam.engine.core.output.MultiValue;
import org.smartparam.engine.core.output.ParamValue;
import org.smartparam.engine.core.type.ValueHolder;
import org.smartparam.engine.util.MultiValueUtil;
import org.springframework.stereotype.Service;
import pl.decerto.hyperon.rest.execution.ExecutionElementIdentifier;
import pl.decerto.hyperon.rest.execution.ExecutionService;
import pl.decerto.hyperon.rest.execution.ExecutionServiceImpl;
import pl.decerto.hyperon.rest.execution.MissingAttributeException;
import pl.decerto.hyperon.rest.execution.MppResultField;
import pl.decerto.hyperon.rest.execution.MppResultRow;
import pl.decerto.hyperon.runtime.core.HyperonContext;
import pl.decerto.hyperon.runtime.core.HyperonEngine;
import pl.decerto.hyperon.runtime.model.HyperonDomainAttribute;
import pl.decerto.hyperon.runtime.model.HyperonDomainObject;

@Service
public class ExecutionServiceImpl
implements ExecutionService {
    private static final Logger log = LoggerFactory.getLogger(ExecutionServiceImpl.class);
    private final HyperonEngine hyperonEngine;

    public Object execute(ExecutionElementIdentifier element, HyperonContext ctx, Object ... args) {
        log.debug("Executing element: {}", (Object)element);
        switch (1.$SwitchMap$pl$decerto$hyperon$runtime$model$MpElementType[element.getType().ordinal()]) {
            case 1: {
                return this.callFunction(element.getCode(), ctx, args);
            }
            case 2: {
                return this.getParameter(element.getCode(), ctx);
            }
            case 3: {
                return this.callDomain(element.getProfileCode(), element.getCode(), element.getAttributeCode(), ctx);
            }
        }
        return null;
    }

    private List<MppResultRow> callDomain(String profileCode, String domainPath, String attributeCode, HyperonContext ctx) {
        HyperonDomainObject domainObject = this.hyperonEngine.getDomain(profileCode, domainPath);
        HyperonDomainAttribute attr = domainObject.getAttr(attributeCode);
        if (Objects.isNull(attr)) {
            return this.callDynamicAttribute(attributeCode, ctx, domainObject);
        }
        ParamValue value = attr.getValue((ParamContext)ctx, new Object[0]);
        return this.getResultRows(value);
    }

    private List<MppResultRow> callDynamicAttribute(String attributeCode, HyperonContext ctx, HyperonDomainObject domainObject) {
        HyperonDomainAttribute dynamicAttribute = domainObject.getDynamicAttribute(attributeCode);
        if (Objects.isNull(dynamicAttribute)) {
            throw new MissingAttributeException("missing domain attribute:" + attributeCode);
        }
        ParamValue value = dynamicAttribute.getValue((ParamContext)ctx, new Object[0]);
        return this.getResultRows(value);
    }

    private List<MppResultRow> getParameter(String parameterCode, HyperonContext ctx) {
        log.debug("Executing parameter:{}", (Object)parameterCode);
        ParamValue elementExecResult = this.hyperonEngine.get(parameterCode, (ParamContext)ctx);
        if (elementExecResult != null) {
            log.debug("Parameter result class = {}", (Object)elementExecResult.getClass().getName());
            return this.getResultRows(elementExecResult);
        }
        log.debug("Parameter result is empty, returning empty list");
        return Collections.emptyList();
    }

    private Object callFunction(String functionCode, HyperonContext ctx, Object ... args) {
        log.debug("Executing function:{}", (Object)functionCode);
        Object elementExecResult = this.hyperonEngine.call(functionCode, (ParamContext)ctx, args);
        if (elementExecResult instanceof ParamValue) {
            elementExecResult = this.getResultRows((ParamValue)elementExecResult);
        }
        return elementExecResult;
    }

    private List<MppResultRow> getResultRows(ParamValue value) {
        log.debug("Extracting result rows from param value:{}", (Object)value);
        return value.stream().map(arg_0 -> this.convertToRow(arg_0)).collect(Collectors.toList());
    }

    private MppResultRow convertToRow(MultiValue mv) {
        List fields = this.processFields(mv);
        MppResultRow row = new MppResultRow();
        row.setFields(fields);
        return row;
    }

    private List<MppResultField> processFields(MultiValue mv) {
        List fieldKeys = MultiValueUtil.getKeys((MultiValue)mv);
        if (fieldKeys.isEmpty()) {
            return this.getResultsFromLiteralMultiValue(mv);
        }
        return this.processFields(mv, fieldKeys);
    }

    private List<MppResultField> getResultsFromLiteralMultiValue(MultiValue mv) {
        return Arrays.stream(mv.unwrap()).map(arg_0 -> this.createResultField(arg_0)).collect(Collectors.toList());
    }

    private MppResultField createResultField(Object o) {
        MppResultField field = new MppResultField();
        field.setValue(Objects.isNull(o) ? null : o.toString());
        return field;
    }

    private List<MppResultField> processFields(MultiValue mv, List<String> fieldKeys) {
        return fieldKeys.stream().map(key -> this.convertToField(mv, key)).collect(Collectors.toList());
    }

    private MppResultField convertToField(MultiValue mv, String key) {
        MppResultField field = new MppResultField();
        field.setField(key);
        if (mv.isArray(key)) {
            field.setValues(mv.getStringArray(key));
            return field;
        }
        ValueHolder holder = mv.getHolder(key);
        field.setValue(holder.getString());
        return field;
    }

    public ExecutionServiceImpl(HyperonEngine hyperonEngine) {
        this.hyperonEngine = hyperonEngine;
    }
}

