/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.execution.dto;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;

public class JsonDateDeserializer
extends JsonDeserializer<Date> {
    public Date deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String date = jsonParser.getText();
        try {
            return format.parse(date);
        }
        catch (ParseException e) {
            throw new HyperonRuntimeException(String.format("Cannot deserialize date: %s", date), (Throwable)e);
        }
    }
}

