/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.net.Uri;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Locale;
import pl.droidsonroids.gif.GifDrawable;

public class GifAnimationMetaData
implements Serializable {
    private static final long serialVersionUID = 6518019337497570800L;
    private final int[] mMetaData = new int[5];

    public GifAnimationMetaData(Resources res, int id) throws Resources.NotFoundException, IOException {
        this(res.openRawResourceFd(id));
    }

    public GifAnimationMetaData(AssetManager assets, String assetName) throws IOException {
        this(assets.openFd(assetName));
    }

    public GifAnimationMetaData(String filePath) throws IOException {
        if (filePath == null) {
            throw new NullPointerException("Source is null");
        }
        this.init(GifDrawable.openFile(this.mMetaData, filePath, true));
    }

    public GifAnimationMetaData(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("Source is null");
        }
        this.init(GifDrawable.openFile(this.mMetaData, file.getPath(), true));
    }

    public GifAnimationMetaData(InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("Source is null");
        }
        if (!stream.markSupported()) {
            throw new IllegalArgumentException("InputStream does not support marking");
        }
        this.init(GifDrawable.openStream(this.mMetaData, stream, true));
    }

    public GifAnimationMetaData(AssetFileDescriptor afd) throws IOException {
        if (afd == null) {
            throw new NullPointerException("Source is null");
        }
        FileDescriptor fd = afd.getFileDescriptor();
        try {
            this.init(GifDrawable.openFd(this.mMetaData, fd, afd.getStartOffset(), true));
        }
        catch (IOException ex) {
            afd.close();
            throw ex;
        }
    }

    public GifAnimationMetaData(FileDescriptor fd) throws IOException {
        if (fd == null) {
            throw new NullPointerException("Source is null");
        }
        this.init(GifDrawable.openFd(this.mMetaData, fd, 0L, true));
    }

    public GifAnimationMetaData(byte[] bytes) throws IOException {
        if (bytes == null) {
            throw new NullPointerException("Source is null");
        }
        this.init(GifDrawable.openByteArray(this.mMetaData, bytes, true));
    }

    public GifAnimationMetaData(ByteBuffer buffer) throws IOException {
        if (buffer == null) {
            throw new NullPointerException("Source is null");
        }
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("ByteBuffer is not direct");
        }
        this.init(GifDrawable.openDirectByteBuffer(this.mMetaData, buffer, true));
    }

    public GifAnimationMetaData(ContentResolver resolver, Uri uri) throws IOException {
        this(resolver.openAssetFileDescriptor(uri, "r"));
    }

    private void init(int gifInfoPtr) {
        this.mMetaData[3] = GifDrawable.getLoopCount(gifInfoPtr);
        this.mMetaData[4] = GifDrawable.getDuration(gifInfoPtr);
        GifDrawable.free(gifInfoPtr);
    }

    public int getWidth() {
        return this.mMetaData[0];
    }

    public int getHeight() {
        return this.mMetaData[1];
    }

    public int getNumberOfFrames() {
        return this.mMetaData[2];
    }

    public int getLoopCount() {
        return this.mMetaData[3];
    }

    public int getDuration() {
        return this.mMetaData[4];
    }

    public boolean isAnimated() {
        return this.mMetaData[2] > 1 && this.mMetaData[4] > 0;
    }

    public String toString() {
        String loopCount = this.mMetaData[3] == 0 ? "Infinity" : Integer.toString(this.mMetaData[3]);
        String suffix = String.format(Locale.US, "GIF: size: %dx%d, frames: %d, loops: %s, duration: %d", this.mMetaData[0], this.mMetaData[1], this.mMetaData[2], loopCount, this.mMetaData[4]);
        return this.isAnimated() ? "Animated " + suffix : suffix;
    }
}

