/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.ImageView;
import java.io.IOException;
import pl.droidsonroids.gif.GifDrawable;

public class GifImageView
extends ImageView {
    static final String ANDROID_NS = "http://schemas.android.com/apk/res/android";

    public GifImageView(Context context) {
        super(context);
    }

    public GifImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.trySetGifDrawable(attrs, this.getResources());
    }

    public GifImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.trySetGifDrawable(attrs, this.getResources());
    }

    public void setImageResource(int resId) {
        this.setResource(true, resId, this.getResources());
    }

    public void setBackgroundResource(int resId) {
        this.setResource(false, resId, this.getResources());
    }

    void trySetGifDrawable(AttributeSet attrs, Resources res) {
        if (attrs != null && res != null && !this.isInEditMode()) {
            int resId = attrs.getAttributeResourceValue(ANDROID_NS, "src", -1);
            if (resId > 0 && "drawable".equals(res.getResourceTypeName(resId))) {
                this.setResource(true, resId, res);
            }
            if ((resId = attrs.getAttributeResourceValue(ANDROID_NS, "background", -1)) > 0 && "drawable".equals(res.getResourceTypeName(resId))) {
                this.setResource(false, resId, res);
            }
        }
    }

    @TargetApi(value=16)
    void setResource(boolean isSrc, int resId, Resources res) {
        try {
            GifDrawable d = new GifDrawable(res, resId);
            if (isSrc) {
                this.setImageDrawable(d);
            } else if (Build.VERSION.SDK_INT >= 16) {
                this.setBackground(d);
            } else {
                this.setBackgroundDrawable(d);
            }
            return;
        }
        catch (IOException e) {
        }
        catch (Resources.NotFoundException e) {
            // empty catch block
        }
        if (isSrc) {
            super.setImageResource(resId);
        } else {
            super.setBackgroundResource(resId);
        }
    }
}

