/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.widget.MediaController;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import pl.droidsonroids.gif.GifError;
import pl.droidsonroids.gif.GifIOException;

public class GifDrawable
extends Drawable
implements Animatable,
MediaController.MediaPlayerControl {
    private static final Handler UI_HANDLER;
    private volatile int mGifInfoPtr;
    private volatile boolean mIsRunning = true;
    private final int[] mMetaData = new int[5];
    private final long mInputSourceLength;
    private float mSx = 1.0f;
    private float mSy = 1.0f;
    private boolean mApplyTransformation;
    private final Rect mDstRect = new Rect();
    protected final Paint mPaint = new Paint(6);
    private int[] mColors;
    private final Runnable mResetTask = new Runnable(){

        @Override
        public void run() {
            GifDrawable.reset(GifDrawable.this.mGifInfoPtr);
        }
    };
    private final Runnable mStartTask = new Runnable(){

        @Override
        public void run() {
            GifDrawable.restoreRemainder(GifDrawable.this.mGifInfoPtr);
            GifDrawable.this.invalidateSelf();
        }
    };
    private final Runnable mSaveRemainderTask = new Runnable(){

        @Override
        public void run() {
            GifDrawable.saveRemainder(GifDrawable.this.mGifInfoPtr);
        }
    };
    private final Runnable mInvalidateTask = new Runnable(){

        @Override
        public void run() {
            GifDrawable.this.invalidateSelf();
        }
    };

    private static native void renderFrame(int[] var0, int var1, int[] var2);

    private static native int openFd(int[] var0, FileDescriptor var1, long var2) throws GifIOException;

    private static native int openByteArray(int[] var0, byte[] var1) throws GifIOException;

    private static native int openDirectByteBuffer(int[] var0, ByteBuffer var1) throws GifIOException;

    private static native int openStream(int[] var0, InputStream var1) throws GifIOException;

    private static native int openFile(int[] var0, String var1) throws GifIOException;

    private static native void free(int var0);

    private static native void reset(int var0);

    private static native void setSpeedFactor(int var0, float var1);

    private static native String getComment(int var0);

    private static native int getLoopCount(int var0);

    private static native int getDuration(int var0);

    private static native int getCurrentPosition(int var0);

    private static native int seekToTime(int var0, int var1, int[] var2);

    private static native int seekToFrame(int var0, int var1, int[] var2);

    private static native int saveRemainder(int var0);

    private static native int restoreRemainder(int var0);

    private static native long getAllocationByteCount(int var0);

    private static void runOnUiThread(Runnable task) {
        if (Looper.myLooper() == UI_HANDLER.getLooper()) {
            task.run();
        } else {
            UI_HANDLER.post(task);
        }
    }

    public GifDrawable(Resources res, int id) throws Resources.NotFoundException, IOException {
        this(res.openRawResourceFd(id));
    }

    public GifDrawable(AssetManager assets, String assetName) throws IOException {
        this(assets.openFd(assetName));
    }

    public GifDrawable(String filePath) throws IOException {
        if (filePath == null) {
            throw new NullPointerException("Source is null");
        }
        this.mInputSourceLength = new File(filePath).length();
        this.mGifInfoPtr = GifDrawable.openFile(this.mMetaData, filePath);
        this.mColors = new int[this.mMetaData[0] * this.mMetaData[1]];
    }

    public GifDrawable(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("Source is null");
        }
        this.mInputSourceLength = file.length();
        this.mGifInfoPtr = GifDrawable.openFile(this.mMetaData, file.getPath());
        this.mColors = new int[this.mMetaData[0] * this.mMetaData[1]];
    }

    public GifDrawable(InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("Source is null");
        }
        if (!stream.markSupported()) {
            throw new IllegalArgumentException("InputStream does not support marking");
        }
        this.mGifInfoPtr = GifDrawable.openStream(this.mMetaData, stream);
        this.mColors = new int[this.mMetaData[0] * this.mMetaData[1]];
        this.mInputSourceLength = -1L;
    }

    public GifDrawable(AssetFileDescriptor afd) throws IOException {
        if (afd == null) {
            throw new NullPointerException("Source is null");
        }
        FileDescriptor fd = afd.getFileDescriptor();
        try {
            this.mGifInfoPtr = GifDrawable.openFd(this.mMetaData, fd, afd.getStartOffset());
        }
        catch (IOException ex) {
            afd.close();
            throw ex;
        }
        this.mColors = new int[this.mMetaData[0] * this.mMetaData[1]];
        this.mInputSourceLength = afd.getLength();
    }

    public GifDrawable(FileDescriptor fd) throws IOException {
        if (fd == null) {
            throw new NullPointerException("Source is null");
        }
        this.mGifInfoPtr = GifDrawable.openFd(this.mMetaData, fd, 0L);
        this.mColors = new int[this.mMetaData[0] * this.mMetaData[1]];
        this.mInputSourceLength = -1L;
    }

    public GifDrawable(byte[] bytes) throws IOException {
        if (bytes == null) {
            throw new NullPointerException("Source is null");
        }
        this.mGifInfoPtr = GifDrawable.openByteArray(this.mMetaData, bytes);
        this.mColors = new int[this.mMetaData[0] * this.mMetaData[1]];
        this.mInputSourceLength = bytes.length;
    }

    public GifDrawable(ByteBuffer buffer) throws IOException {
        if (buffer == null) {
            throw new NullPointerException("Source is null");
        }
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("ByteBuffer is not direct");
        }
        this.mGifInfoPtr = GifDrawable.openDirectByteBuffer(this.mMetaData, buffer);
        this.mColors = new int[this.mMetaData[0] * this.mMetaData[1]];
        this.mInputSourceLength = buffer.capacity();
    }

    public GifDrawable(ContentResolver resolver, Uri uri) throws IOException {
        this(resolver.openAssetFileDescriptor(uri, "r"));
    }

    public void recycle() {
        this.mIsRunning = false;
        int tmpPtr = this.mGifInfoPtr;
        this.mGifInfoPtr = 0;
        this.mColors = null;
        GifDrawable.free(tmpPtr);
    }

    protected void finalize() throws Throwable {
        try {
            this.recycle();
        }
        finally {
            super.finalize();
        }
    }

    public int getIntrinsicHeight() {
        return this.mMetaData[1];
    }

    public int getIntrinsicWidth() {
        return this.mMetaData[0];
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -2;
    }

    public void start() {
        this.mIsRunning = true;
        GifDrawable.runOnUiThread(this.mStartTask);
    }

    public void reset() {
        GifDrawable.runOnUiThread(this.mResetTask);
    }

    public void stop() {
        this.mIsRunning = false;
        GifDrawable.runOnUiThread(this.mSaveRemainderTask);
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    public String getComment() {
        return GifDrawable.getComment(this.mGifInfoPtr);
    }

    public int getLoopCount() {
        return GifDrawable.getLoopCount(this.mGifInfoPtr);
    }

    public String toString() {
        return String.format(Locale.US, "Size: %dx%d, %d frames, error: %d", this.mMetaData[0], this.mMetaData[1], this.mMetaData[2], this.mMetaData[3]);
    }

    public int getNumberOfFrames() {
        return this.mMetaData[2];
    }

    public GifError getError() {
        return GifError.fromCode(this.mMetaData[3]);
    }

    public static GifDrawable createFromResource(Resources res, int resourceId) {
        try {
            return new GifDrawable(res, resourceId);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void setSpeed(float factor) {
        if (factor <= 0.0f) {
            throw new IllegalArgumentException("Speed factor is not positive");
        }
        GifDrawable.setSpeedFactor(this.mGifInfoPtr, factor);
    }

    public void pause() {
        this.stop();
    }

    public int getDuration() {
        return GifDrawable.getDuration(this.mGifInfoPtr);
    }

    public int getCurrentPosition() {
        return GifDrawable.getCurrentPosition(this.mGifInfoPtr);
    }

    public void seekTo(final int position) {
        if (position < 0) {
            throw new IllegalArgumentException("Position is not positive");
        }
        GifDrawable.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                GifDrawable.seekToTime(GifDrawable.this.mGifInfoPtr, position, GifDrawable.this.mColors);
                GifDrawable.this.invalidateSelf();
            }
        });
    }

    public void seekToFrame(final int frameIndex) {
        if (frameIndex < 0) {
            throw new IllegalArgumentException("frameIndex is not positive");
        }
        GifDrawable.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                GifDrawable.seekToFrame(GifDrawable.this.mGifInfoPtr, frameIndex, GifDrawable.this.mColors);
                GifDrawable.this.invalidateSelf();
            }
        });
    }

    public boolean isPlaying() {
        return this.mIsRunning;
    }

    public int getBufferPercentage() {
        return 100;
    }

    public boolean canPause() {
        return true;
    }

    public boolean canSeekBackward() {
        return false;
    }

    public boolean canSeekForward() {
        return this.getNumberOfFrames() > 1;
    }

    public int getAudioSessionId() {
        return 0;
    }

    public int getFrameByteCount() {
        return this.mMetaData[0] * this.mMetaData[1] * 4;
    }

    public long getAllocationByteCount() {
        long nativeSize = GifDrawable.getAllocationByteCount(this.mGifInfoPtr);
        int[] colors = this.mColors;
        if (colors == null) {
            return nativeSize;
        }
        return nativeSize + (long)colors.length * 4L;
    }

    public long getInputSourceByteCount() {
        return this.mInputSourceLength;
    }

    public void getPixels(int[] pixels) {
        int[] colors = this.mColors;
        if (colors == null) {
            return;
        }
        if (pixels.length < colors.length) {
            throw new ArrayIndexOutOfBoundsException("Pixels array is too small. Required length: " + colors.length);
        }
        System.arraycopy(colors, 0, pixels, 0, colors.length);
    }

    public int getPixel(int x, int y) {
        if (x < 0) {
            throw new IllegalArgumentException("x must be >= 0");
        }
        if (y < 0) {
            throw new IllegalArgumentException("y must be >= 0");
        }
        if (x >= this.mMetaData[0]) {
            throw new IllegalArgumentException("x must be < GIF width");
        }
        if (y >= this.mMetaData[1]) {
            throw new IllegalArgumentException("y must be < GIF height");
        }
        int[] colors = this.mColors;
        if (colors == null) {
            throw new IllegalArgumentException("GifDrawable is recycled");
        }
        return colors[this.mMetaData[1] * y + x];
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mApplyTransformation = true;
    }

    public void draw(Canvas canvas) {
        if (this.mApplyTransformation) {
            this.mDstRect.set(this.getBounds());
            this.mSx = (float)this.mDstRect.width() / (float)this.mMetaData[0];
            this.mSy = (float)this.mDstRect.height() / (float)this.mMetaData[1];
            this.mApplyTransformation = false;
        }
        if (this.mPaint.getShader() == null) {
            if (this.mIsRunning) {
                GifDrawable.renderFrame(this.mColors, this.mGifInfoPtr, this.mMetaData);
            } else {
                this.mMetaData[4] = -1;
            }
            canvas.scale(this.mSx, this.mSy);
            int[] colors = this.mColors;
            if (colors != null) {
                canvas.drawBitmap(colors, 0, this.mMetaData[0], 0.0f, 0.0f, this.mMetaData[0], this.mMetaData[1], true, this.mPaint);
            }
            if (this.mMetaData[4] >= 0 && this.mMetaData[2] > 1) {
                UI_HANDLER.postDelayed(this.mInvalidateTask, (long)this.mMetaData[4]);
            }
        } else {
            canvas.drawRect(this.mDstRect, this.mPaint);
        }
    }

    public final Paint getPaint() {
        return this.mPaint;
    }

    public int getAlpha() {
        return this.mPaint.getAlpha();
    }

    public void setFilterBitmap(boolean filter) {
        this.mPaint.setFilterBitmap(filter);
        this.invalidateSelf();
    }

    public void setDither(boolean dither) {
        this.mPaint.setDither(dither);
        this.invalidateSelf();
    }

    public int getMinimumHeight() {
        return this.mMetaData[1];
    }

    public int getMinimumWidth() {
        return this.mMetaData[0];
    }

    static {
        System.loadLibrary("gif");
        UI_HANDLER = new Handler(Looper.getMainLooper());
    }
}

