/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.graphics.Bitmap;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.IOException;
import pl.droidsonroids.gif.GifInfoHandle;
import pl.droidsonroids.gif.GifOptions;
import pl.droidsonroids.gif.InputSource;

public class GifDecoder {
    private final GifInfoHandle mGifInfoHandle;

    public GifDecoder(@NonNull InputSource inputSource) throws IOException {
        this(inputSource, null);
    }

    public GifDecoder(@NonNull InputSource inputSource, @Nullable GifOptions options) throws IOException {
        this.mGifInfoHandle = inputSource.open();
        if (options != null) {
            this.mGifInfoHandle.setOptions(options.inSampleSize, options.inIsOpaque);
        }
    }

    public String getComment() {
        return this.mGifInfoHandle.getComment();
    }

    public int getLoopCount() {
        return this.mGifInfoHandle.getLoopCount();
    }

    public long getSourceLength() {
        return this.mGifInfoHandle.getSourceLength();
    }

    public void seekToTime(@IntRange(from=0L, to=0x7FFFFFFFL) int position, @NonNull Bitmap buffer) {
        this.checkBuffer(buffer);
        this.mGifInfoHandle.seekToTime(position, buffer);
    }

    public void seekToFrame(@IntRange(from=0L, to=0x7FFFFFFFL) int frameIndex, @NonNull Bitmap buffer) {
        this.checkBuffer(buffer);
        this.mGifInfoHandle.seekToFrame(frameIndex, buffer);
    }

    public long getAllocationByteCount() {
        return this.mGifInfoHandle.getAllocationByteCount();
    }

    public int getFrameDuration(@IntRange(from=0L) int index) {
        return this.mGifInfoHandle.getFrameDuration(index);
    }

    public int getDuration() {
        return this.mGifInfoHandle.getDuration();
    }

    public int getWidth() {
        return this.mGifInfoHandle.getWidth();
    }

    public int getHeight() {
        return this.mGifInfoHandle.getHeight();
    }

    public int getNumberOfFrames() {
        return this.mGifInfoHandle.getNumberOfFrames();
    }

    public boolean isAnimated() {
        return this.mGifInfoHandle.getNumberOfFrames() > 1 && this.getDuration() > 0;
    }

    public void recycle() {
        this.mGifInfoHandle.recycle();
    }

    private void checkBuffer(Bitmap buffer) {
        if (buffer.isRecycled()) {
            throw new IllegalArgumentException("Bitmap is recycled");
        }
        if (buffer.getWidth() < this.mGifInfoHandle.getWidth() || buffer.getHeight() < this.mGifInfoHandle.getHeight()) {
            throw new IllegalArgumentException("Bitmap ia too small, size must be greater than or equal to GIF size");
        }
    }
}

