/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import java.io.IOException;
import pl.droidsonroids.gif.GifDrawable;
import pl.droidsonroids.gif.GifViewSavedState;
import pl.droidsonroids.gif.GifViewUtils;

public class GifTextView
extends TextView {
    private boolean mFreezesAnimation;

    public GifTextView(Context context) {
        super(context);
    }

    public GifTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0, 0);
    }

    public GifTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle, 0);
    }

    @TargetApi(value=21)
    public GifTextView(Context context, AttributeSet attrs, int defStyle, int defStyleRes) {
        super(context, attrs, defStyle, defStyleRes);
        this.init(attrs, defStyle, defStyleRes);
    }

    @TargetApi(value=17)
    private void init(AttributeSet attrs, int defStyle, int defStyleRes) {
        if (attrs != null) {
            Drawable left = this.getGifOrDefaultDrawable(attrs.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "drawableLeft", 0));
            Drawable top = this.getGifOrDefaultDrawable(attrs.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "drawableTop", 0));
            Drawable right = this.getGifOrDefaultDrawable(attrs.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "drawableRight", 0));
            Drawable bottom = this.getGifOrDefaultDrawable(attrs.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "drawableBottom", 0));
            Drawable start = this.getGifOrDefaultDrawable(attrs.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "drawableStart", 0));
            Drawable end = this.getGifOrDefaultDrawable(attrs.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "drawableEnd", 0));
            if (Build.VERSION.SDK_INT >= 17) {
                if (this.getLayoutDirection() == 0) {
                    if (start == null) {
                        start = left;
                    }
                    if (end == null) {
                        end = right;
                    }
                } else {
                    if (start == null) {
                        start = right;
                    }
                    if (end == null) {
                        end = left;
                    }
                }
                this.setCompoundDrawablesRelativeWithIntrinsicBounds(start, top, end, bottom);
                this.setCompoundDrawablesWithIntrinsicBounds(left, top, right, bottom);
            } else {
                this.setCompoundDrawablesWithIntrinsicBounds(left, top, right, bottom);
            }
            this.setBackgroundInternal(this.getGifOrDefaultDrawable(attrs.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "background", 0)));
        }
        this.mFreezesAnimation = GifViewUtils.isFreezingAnimation((View)this, attrs, defStyle, defStyleRes);
    }

    @TargetApi(value=16)
    private void setBackgroundInternal(Drawable bg) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(bg);
        } else {
            this.setBackgroundDrawable(bg);
        }
    }

    public void setBackgroundResource(int resid) {
        this.setBackgroundInternal(this.getGifOrDefaultDrawable(resid));
    }

    @TargetApi(value=21)
    private Drawable getGifOrDefaultDrawable(int resId) {
        if (resId == 0) {
            return null;
        }
        Resources resources = this.getResources();
        if (!this.isInEditMode() && "drawable".equals(resources.getResourceTypeName(resId))) {
            try {
                return new GifDrawable(resources, resId);
            }
            catch (Resources.NotFoundException | IOException throwable) {
                // empty catch block
            }
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return resources.getDrawable(resId, this.getContext().getTheme());
        }
        return resources.getDrawable(resId);
    }

    @TargetApi(value=17)
    public void setCompoundDrawablesRelativeWithIntrinsicBounds(int start, int top, int end, int bottom) {
        this.setCompoundDrawablesRelativeWithIntrinsicBounds(this.getGifOrDefaultDrawable(start), this.getGifOrDefaultDrawable(top), this.getGifOrDefaultDrawable(end), this.getGifOrDefaultDrawable(bottom));
    }

    public void setCompoundDrawablesWithIntrinsicBounds(int left, int top, int right, int bottom) {
        this.setCompoundDrawablesWithIntrinsicBounds(this.getGifOrDefaultDrawable(left), this.getGifOrDefaultDrawable(top), this.getGifOrDefaultDrawable(right), this.getGifOrDefaultDrawable(bottom));
    }

    @TargetApi(value=17)
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.hideCompoundDrawables(this.getCompoundDrawables());
        if (Build.VERSION.SDK_INT >= 17) {
            this.hideCompoundDrawables(this.getCompoundDrawablesRelative());
        }
    }

    private void hideCompoundDrawables(Drawable[] drawables) {
        for (Drawable d : drawables) {
            if (d == null) continue;
            d.setVisible(false, false);
        }
    }

    @TargetApi(value=17)
    public Parcelable onSaveInstanceState() {
        Drawable[] savedDrawables = new Drawable[7];
        if (this.mFreezesAnimation) {
            Drawable[] compoundDrawables = this.getCompoundDrawables();
            System.arraycopy(compoundDrawables, 0, savedDrawables, 0, compoundDrawables.length);
            if (Build.VERSION.SDK_INT >= 17) {
                Drawable[] compoundDrawablesRelative = this.getCompoundDrawablesRelative();
                savedDrawables[4] = compoundDrawablesRelative[0];
                savedDrawables[5] = compoundDrawablesRelative[2];
            }
            savedDrawables[6] = this.getBackground();
        }
        return new GifViewSavedState(super.onSaveInstanceState(), savedDrawables);
    }

    @TargetApi(value=17)
    public void onRestoreInstanceState(Parcelable state) {
        GifViewSavedState ss = (GifViewSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        Drawable[] compoundDrawables = this.getCompoundDrawables();
        ss.setPosition(compoundDrawables[0], 0);
        ss.setPosition(compoundDrawables[1], 1);
        ss.setPosition(compoundDrawables[2], 2);
        ss.setPosition(compoundDrawables[3], 3);
        if (Build.VERSION.SDK_INT >= 17) {
            Drawable[] compoundDrawablesRelative = this.getCompoundDrawablesRelative();
            ss.setPosition(compoundDrawablesRelative[0], 4);
            ss.setPosition(compoundDrawablesRelative[2], 5);
        }
        ss.setPosition(this.getBackground(), 6);
    }

    public void setFreezesAnimation(boolean freezesAnimation) {
        this.mFreezesAnimation = freezesAnimation;
    }
}

