/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.widget.ImageView;
import java.io.IOException;
import pl.droidsonroids.gif.GifIOException;
import pl.droidsonroids.gif.GifInfoHandle;
import pl.droidsonroids.gif.GifViewSavedState;
import pl.droidsonroids.gif.GifViewUtils;
import pl.droidsonroids.gif.InputSource;
import pl.droidsonroids.gif.R;

@TargetApi(value=14)
public class GifTextureView
extends TextureView {
    private ImageView.ScaleType mScaleType = ImageView.ScaleType.FIT_CENTER;
    private final Matrix mTransform = new Matrix();
    private InputSource mInputSource;
    private boolean mFreezesAnimation;
    private RenderThread mRenderThread = new RenderThread();
    private float mSpeedFactor = 1.0f;
    private static final ImageView.ScaleType[] sScaleTypeArray = new ImageView.ScaleType[]{ImageView.ScaleType.MATRIX, ImageView.ScaleType.FIT_XY, ImageView.ScaleType.FIT_START, ImageView.ScaleType.FIT_CENTER, ImageView.ScaleType.FIT_END, ImageView.ScaleType.CENTER, ImageView.ScaleType.CENTER_CROP, ImageView.ScaleType.CENTER_INSIDE};

    public GifTextureView(Context context) {
        super(context);
    }

    public GifTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0, 0);
    }

    public GifTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public GifTextureView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs, defStyleAttr, defStyleRes);
    }

    private void init(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (attrs != null && !this.isInEditMode()) {
            int scaleTypeIndex = attrs.getAttributeIntValue("http://schemas.android.com/apk/res/android", "scaleType", -1);
            if (scaleTypeIndex >= 0 && scaleTypeIndex < sScaleTypeArray.length) {
                this.mScaleType = sScaleTypeArray[scaleTypeIndex];
            }
            TypedArray textureViewAttributes = this.getContext().obtainStyledAttributes(attrs, R.styleable.GifTextureView, defStyleAttr, defStyleRes);
            this.mInputSource = GifTextureView.findSource(textureViewAttributes);
            this.setOpaque(textureViewAttributes.getBoolean(R.styleable.GifTextureView_isOpaque, false));
            textureViewAttributes.recycle();
            this.mFreezesAnimation = GifViewUtils.isFreezingAnimation((View)this, attrs, defStyleAttr, defStyleRes);
        } else {
            this.setOpaque(false);
        }
        if (this.mInputSource != null) {
            this.mRenderThread.start();
        }
    }

    public void setSurfaceTextureListener(TextureView.SurfaceTextureListener listener) {
        throw new UnsupportedOperationException("Changing SurfaceTextureListener is not supported");
    }

    public TextureView.SurfaceTextureListener getSurfaceTextureListener() {
        return null;
    }

    public void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        throw new UnsupportedOperationException("Changing SurfaceTexture is not supported");
    }

    private static InputSource findSource(TypedArray textureViewAttributes) {
        TypedValue value = new TypedValue();
        if (!textureViewAttributes.getValue(R.styleable.GifTextureView_src, value)) {
            return null;
        }
        if (value.resourceId != 0) {
            String type = textureViewAttributes.getResources().getResourceTypeName(value.resourceId);
            if ("drawable".equals(type) || "raw".equals(type)) {
                return new InputSource.ResourcesSource(textureViewAttributes.getResources(), value.resourceId);
            }
            if (!"string".equals(type)) {
                throw new IllegalArgumentException("Expected string, drawable or raw resource, type " + type + " cannot be converted to GIF");
            }
        }
        return new InputSource.AssetSource(textureViewAttributes.getResources().getAssets(), value.string.toString());
    }

    protected void onDetachedFromWindow() {
        this.mRenderThread.dispose();
        super.onDetachedFromWindow();
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (surfaceTexture != null) {
            surfaceTexture.release();
        }
    }

    public synchronized void setInputSource(@Nullable InputSource inputSource) {
        this.mRenderThread.dispose();
        this.mInputSource = inputSource;
        this.mRenderThread = new RenderThread();
        if (inputSource != null) {
            this.mRenderThread.start();
        }
    }

    public void setSpeed(float factor) {
        this.mSpeedFactor = factor;
        this.mRenderThread.mGifInfoHandle.setSpeedFactor(factor);
    }

    @Nullable
    public IOException getIOException() {
        if (this.mRenderThread.mIOException != null) {
            return this.mRenderThread.mIOException;
        }
        return GifIOException.fromCode(this.mRenderThread.mGifInfoHandle.getNativeErrorCode());
    }

    public void setScaleType(@NonNull ImageView.ScaleType scaleType) {
        this.mScaleType = scaleType;
        this.updateTextureViewSize(this.mRenderThread.mGifInfoHandle);
    }

    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    private void updateTextureViewSize(GifInfoHandle gifInfoHandle) {
        Matrix transform = new Matrix();
        float viewWidth = this.getWidth();
        float viewHeight = this.getHeight();
        float scaleX = (float)gifInfoHandle.width / viewWidth;
        float scaleY = (float)gifInfoHandle.height / viewHeight;
        RectF src = new RectF(0.0f, 0.0f, (float)gifInfoHandle.width, (float)gifInfoHandle.height);
        RectF dst = new RectF(0.0f, 0.0f, viewWidth, viewHeight);
        switch (this.mScaleType) {
            case CENTER: {
                transform.setScale(scaleX, scaleY, viewWidth / 2.0f, viewHeight / 2.0f);
                break;
            }
            case CENTER_CROP: {
                float scaleRef = 1.0f / Math.min(scaleX, scaleY);
                transform.setScale(scaleRef * scaleX, scaleRef * scaleY, viewWidth / 2.0f, viewHeight / 2.0f);
                break;
            }
            case CENTER_INSIDE: {
                float scaleRef = (float)gifInfoHandle.width <= viewWidth && (float)gifInfoHandle.height <= viewHeight ? 1.0f : Math.min(1.0f / scaleX, 1.0f / scaleY);
                transform.setScale(scaleRef * scaleX, scaleRef * scaleY, viewWidth / 2.0f, viewHeight / 2.0f);
                break;
            }
            case FIT_CENTER: {
                transform.setRectToRect(src, dst, Matrix.ScaleToFit.CENTER);
                transform.preScale(scaleX, scaleY);
                break;
            }
            case FIT_END: {
                transform.setRectToRect(src, dst, Matrix.ScaleToFit.END);
                transform.preScale(scaleX, scaleY);
                break;
            }
            case FIT_START: {
                transform.setRectToRect(src, dst, Matrix.ScaleToFit.START);
                transform.preScale(scaleX, scaleY);
                break;
            }
            case FIT_XY: {
                return;
            }
            case MATRIX: {
                transform.set(this.mTransform);
                transform.preScale(scaleX, scaleY);
            }
        }
        super.setTransform(transform);
    }

    public void setImageMatrix(Matrix matrix) {
        this.setTransform(matrix);
    }

    public void setTransform(Matrix transform) {
        this.mTransform.set(transform);
        this.updateTextureViewSize(this.mRenderThread.mGifInfoHandle);
    }

    public Matrix getTransform(Matrix transform) {
        if (transform == null) {
            transform = new Matrix();
        }
        transform.set(this.mTransform);
        return transform;
    }

    public Parcelable onSaveInstanceState() {
        int position;
        if (this.mFreezesAnimation) {
            position = this.mRenderThread.mGifInfoHandle.postUnbindSurface();
            this.mRenderThread.mStartPosition = position;
        } else {
            position = 0;
        }
        return new GifViewSavedState(super.onSaveInstanceState(), position);
    }

    public void onRestoreInstanceState(Parcelable state) {
        GifViewSavedState ss = (GifViewSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mRenderThread.mStartPosition = ss.mPositions[0];
    }

    public void setFreezesAnimation(boolean freezesAnimation) {
        this.mFreezesAnimation = freezesAnimation;
    }

    private class RenderThread
    extends Thread
    implements TextureView.SurfaceTextureListener {
        private int mStartPosition;
        private GifInfoHandle mGifInfoHandle = GifInfoHandle.NULL_INFO;
        private IOException mIOException;
        private Bitmap mLastFrame;

        private RenderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.mGifInfoHandle = GifTextureView.this.mInputSource.open();
            }
            catch (IOException ex) {
                this.mIOException = ex;
                return;
            }
            GifTextureView.super.setSurfaceTextureListener(this);
            GifTextureView.this.post(new Runnable(){

                @Override
                public void run() {
                    GifTextureView.this.updateTextureViewSize(RenderThread.this.mGifInfoHandle);
                }
            });
            this.mGifInfoHandle.setSpeedFactor(GifTextureView.this.mSpeedFactor);
            block10: while (!this.isInterrupted()) {
                SurfaceTexture surfaceTexture = GifTextureView.this.getSurfaceTexture();
                while (surfaceTexture == null) {
                    try {
                        RenderThread renderThread = this;
                        synchronized (renderThread) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        break block10;
                    }
                    surfaceTexture = GifTextureView.this.getSurfaceTexture();
                }
                Surface surface = new Surface(surfaceTexture);
                this.mGifInfoHandle.reset();
                this.mLastFrame = null;
                try {
                    if (!this.mGifInfoHandle.bindSurface(surface, this.mStartPosition)) continue;
                    this.mStartPosition = this.mGifInfoHandle.getCurrentPosition();
                    this.mLastFrame = GifTextureView.this.getBitmap();
                    break;
                }
                finally {
                    surface.release();
                }
            }
            this.mGifInfoHandle.recycle();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            if (this.mLastFrame != null) {
                Surface frameSurface = new Surface(surface);
                Canvas canvas = frameSurface.lockCanvas(null);
                canvas.drawBitmap(this.mLastFrame, 0.0f, 0.0f, new Paint(6));
                frameSurface.unlockCanvasAndPost(canvas);
                frameSurface.release();
            } else {
                GifTextureView.this.updateTextureViewSize(this.mGifInfoHandle);
                RenderThread renderThread = this;
                synchronized (renderThread) {
                    this.notify();
                }
            }
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            this.mStartPosition = this.mGifInfoHandle.postUnbindSurface();
            return false;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        }

        void dispose() {
            GifTextureView.super.setSurfaceTextureListener(null);
            this.mGifInfoHandle.postUnbindSurface();
            GifTextureView.this.mRenderThread.interrupt();
            boolean isCallerInterrupted = Thread.currentThread().isInterrupted();
            if (isCallerInterrupted) {
                RenderThread.interrupted();
            }
            try {
                GifTextureView.this.mRenderThread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (isCallerInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

