/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.os.SystemClock;
import java.util.concurrent.TimeUnit;
import pl.droidsonroids.gif.AnimationListener;
import pl.droidsonroids.gif.GifDrawable;
import pl.droidsonroids.gif.SafeRunnable;

class RenderTask
extends SafeRunnable {
    private final Runnable mNotifyListenersTask = new Runnable(){

        @Override
        public void run() {
            for (AnimationListener listener : RenderTask.this.mGifDrawable.mListeners) {
                listener.onAnimationCompleted();
            }
        }
    };

    RenderTask(GifDrawable gifDrawable) {
        super(gifDrawable);
    }

    @Override
    public void doWork() {
        long renderResult = this.mGifDrawable.mNativeInfoHandle.renderFrame(this.mGifDrawable.mBuffer);
        int invalidationDelay = (int)(renderResult >> 1);
        this.mGifDrawable.mNextFrameRenderTime = SystemClock.elapsedRealtime() + (long)invalidationDelay;
        if ((int)(renderResult & 1L) == 1 && !this.mGifDrawable.mListeners.isEmpty()) {
            this.mGifDrawable.scheduleSelf(this.mNotifyListenersTask, 0L);
        }
        if (invalidationDelay >= 0) {
            if (this.mGifDrawable.isVisible()) {
                if (this.mGifDrawable.mIsRunning && !this.mGifDrawable.mIsRenderingTriggeredOnDraw) {
                    this.mGifDrawable.mExecutor.schedule(this, (long)invalidationDelay, TimeUnit.MILLISECONDS);
                }
                if (!this.mGifDrawable.mInvalidationHandler.hasMessages(0)) {
                    this.mGifDrawable.mInvalidationHandler.sendEmptyMessageAtTime(0, 0L);
                }
            }
        } else {
            this.mGifDrawable.mIsRunning = false;
        }
    }
}

