/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.view.View;
import pl.droidsonroids.gif.GifDrawable;

class GifViewSavedState
extends View.BaseSavedState {
    final long[][] mStates;
    public static final Parcelable.Creator<GifViewSavedState> CREATOR = new Parcelable.Creator<GifViewSavedState>(){

        public GifViewSavedState createFromParcel(Parcel in) {
            return new GifViewSavedState(in);
        }

        public GifViewSavedState[] newArray(int size) {
            return new GifViewSavedState[size];
        }
    };

    GifViewSavedState(Parcelable superState, Drawable ... drawables) {
        super(superState);
        this.mStates = new long[drawables.length][4];
        for (int i = 0; i < drawables.length; ++i) {
            Drawable drawable = drawables[i];
            this.mStates[i] = (long[])(drawable instanceof GifDrawable ? ((GifDrawable)drawable).mNativeInfoHandle.getSavedState() : null);
        }
    }

    private GifViewSavedState(Parcel in) {
        super(in);
        for (long[] mState : this.mStates = new long[in.readInt()][4]) {
            in.readLongArray(mState);
        }
    }

    public GifViewSavedState(Parcelable superState, long[] savedState) {
        super(superState);
        this.mStates = new long[1][3];
        this.mStates[0] = savedState;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.mStates.length);
        for (long[] mState : this.mStates) {
            dest.writeLongArray(mState);
        }
    }

    void restoreState(Drawable drawable, int i) {
        if (this.mStates[i] != null && drawable instanceof GifDrawable) {
            GifDrawable gifDrawable = (GifDrawable)drawable;
            gifDrawable.startAnimation(gifDrawable.mNativeInfoHandle.restoreSavedState(this.mStates[i], gifDrawable.mBuffer));
        }
    }
}

