/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.view.View;
import java.lang.ref.WeakReference;
import java.util.concurrent.CopyOnWriteArrayList;

public class MultiCallback
implements Drawable.Callback {
    private final CopyOnWriteArrayList<ViewWeakReference> mViewList = new CopyOnWriteArrayList();

    public void invalidateDrawable(Drawable who) {
        for (int i = 0; i < this.mViewList.size(); ++i) {
            ViewWeakReference reference = this.mViewList.get(i);
            View view = (View)reference.get();
            if (view != null) {
                view.invalidateDrawable(who);
                continue;
            }
            this.mViewList.remove(reference);
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        for (int i = 0; i < this.mViewList.size(); ++i) {
            ViewWeakReference reference = this.mViewList.get(i);
            View view = (View)reference.get();
            if (view != null) {
                view.scheduleDrawable(who, what, when);
                continue;
            }
            this.mViewList.remove(reference);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        for (int i = 0; i < this.mViewList.size(); ++i) {
            ViewWeakReference reference = this.mViewList.get(i);
            View view = (View)reference.get();
            if (view != null) {
                view.unscheduleDrawable(who);
                continue;
            }
            this.mViewList.remove(reference);
        }
    }

    public void addView(@NonNull View view) {
        for (int i = 0; i < this.mViewList.size(); ++i) {
            ViewWeakReference reference = this.mViewList.get(i);
            View item = (View)reference.get();
            if (item != null) continue;
            this.mViewList.remove(reference);
        }
        this.mViewList.addIfAbsent(new ViewWeakReference(view));
    }

    public void removeView(View view) {
        for (int i = 0; i < this.mViewList.size(); ++i) {
            ViewWeakReference reference = this.mViewList.get(i);
            View item = (View)reference.get();
            if (item != null && item != view) continue;
            this.mViewList.remove(reference);
        }
    }

    private static final class ViewWeakReference
    extends WeakReference<View> {
        ViewWeakReference(View r) {
            super(r);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.get() == ((ViewWeakReference)o).get();
        }

        public int hashCode() {
            View view = (View)this.get();
            return view != null ? view.hashCode() : 0;
        }
    }
}

