/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.SystemClock;
import android.widget.MediaController;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RawRes;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import pl.droidsonroids.gif.AnimationListener;
import pl.droidsonroids.gif.GifError;
import pl.droidsonroids.gif.GifInfoHandle;
import pl.droidsonroids.gif.GifOptions;
import pl.droidsonroids.gif.GifRenderingExecutor;
import pl.droidsonroids.gif.GifViewUtils;
import pl.droidsonroids.gif.InputSource;
import pl.droidsonroids.gif.InvalidationHandler;
import pl.droidsonroids.gif.RenderTask;
import pl.droidsonroids.gif.SafeRunnable;
import pl.droidsonroids.gif.transforms.CornerRadiusTransform;
import pl.droidsonroids.gif.transforms.Transform;

public class GifDrawable
extends Drawable
implements Animatable,
MediaController.MediaPlayerControl {
    final ScheduledThreadPoolExecutor mExecutor;
    volatile boolean mIsRunning = true;
    long mNextFrameRenderTime = Long.MIN_VALUE;
    private final Rect mDstRect = new Rect();
    protected final Paint mPaint = new Paint(6);
    final Bitmap mBuffer;
    final GifInfoHandle mNativeInfoHandle;
    final ConcurrentLinkedQueue<AnimationListener> mListeners = new ConcurrentLinkedQueue();
    private ColorStateList mTint;
    private PorterDuffColorFilter mTintFilter;
    private PorterDuff.Mode mTintMode;
    final boolean mIsRenderingTriggeredOnDraw;
    final InvalidationHandler mInvalidationHandler;
    private final RenderTask mRenderTask = new RenderTask(this);
    private final Rect mSrcRect;
    ScheduledFuture<?> mRenderTaskSchedule;
    private int mScaledWidth;
    private int mScaledHeight;
    private Transform mTransform;

    public GifDrawable(@NonNull Resources res, @RawRes @DrawableRes int id) throws Resources.NotFoundException, IOException {
        this(res.openRawResourceFd(id));
        float densityScale = GifViewUtils.getDensityScale(res, id);
        this.mScaledHeight = (int)((float)this.mNativeInfoHandle.getHeight() * densityScale);
        this.mScaledWidth = (int)((float)this.mNativeInfoHandle.getWidth() * densityScale);
    }

    public GifDrawable(@NonNull AssetManager assets, @NonNull String assetName) throws IOException {
        this(assets.openFd(assetName));
    }

    public GifDrawable(@NonNull String filePath) throws IOException {
        this(new GifInfoHandle(filePath), null, null, true);
    }

    public GifDrawable(@NonNull File file) throws IOException {
        this(file.getPath());
    }

    public GifDrawable(@NonNull InputStream stream) throws IOException {
        this(new GifInfoHandle(stream), null, null, true);
    }

    public GifDrawable(@NonNull AssetFileDescriptor afd) throws IOException {
        this(new GifInfoHandle(afd), null, null, true);
    }

    public GifDrawable(@NonNull FileDescriptor fd) throws IOException {
        this(new GifInfoHandle(fd), null, null, true);
    }

    public GifDrawable(@NonNull byte[] bytes) throws IOException {
        this(new GifInfoHandle(bytes), null, null, true);
    }

    public GifDrawable(@NonNull ByteBuffer buffer) throws IOException {
        this(new GifInfoHandle(buffer), null, null, true);
    }

    public GifDrawable(@Nullable ContentResolver resolver, @NonNull Uri uri) throws IOException {
        this(GifInfoHandle.openUri(resolver, uri), null, null, true);
    }

    protected GifDrawable(@NonNull InputSource inputSource, @Nullable GifDrawable oldDrawable, @Nullable ScheduledThreadPoolExecutor executor, boolean isRenderingTriggeredOnDraw, @NonNull GifOptions options) throws IOException {
        this(inputSource.createHandleWith(options), oldDrawable, executor, isRenderingTriggeredOnDraw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GifDrawable(GifInfoHandle gifInfoHandle, GifDrawable oldDrawable, ScheduledThreadPoolExecutor executor, boolean isRenderingTriggeredOnDraw) {
        this.mIsRenderingTriggeredOnDraw = isRenderingTriggeredOnDraw;
        this.mExecutor = executor != null ? executor : GifRenderingExecutor.getInstance();
        this.mNativeInfoHandle = gifInfoHandle;
        Bitmap oldBitmap = null;
        if (oldDrawable != null) {
            GifInfoHandle gifInfoHandle2 = oldDrawable.mNativeInfoHandle;
            synchronized (gifInfoHandle2) {
                if (!oldDrawable.mNativeInfoHandle.isRecycled() && oldDrawable.mNativeInfoHandle.getHeight() >= this.mNativeInfoHandle.getHeight() && oldDrawable.mNativeInfoHandle.getWidth() >= this.mNativeInfoHandle.getWidth()) {
                    oldDrawable.shutdown();
                    oldBitmap = oldDrawable.mBuffer;
                    oldBitmap.eraseColor(0);
                }
            }
        }
        this.mBuffer = oldBitmap == null ? Bitmap.createBitmap((int)this.mNativeInfoHandle.getWidth(), (int)this.mNativeInfoHandle.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888) : oldBitmap;
        this.mBuffer.setHasAlpha(!gifInfoHandle.isOpaque());
        this.mSrcRect = new Rect(0, 0, this.mNativeInfoHandle.getWidth(), this.mNativeInfoHandle.getHeight());
        this.mInvalidationHandler = new InvalidationHandler(this);
        this.mRenderTask.doWork();
        this.mScaledWidth = this.mNativeInfoHandle.getWidth();
        this.mScaledHeight = this.mNativeInfoHandle.getHeight();
    }

    public void recycle() {
        this.shutdown();
        this.mBuffer.recycle();
    }

    private void shutdown() {
        this.mIsRunning = false;
        this.mInvalidationHandler.removeMessages(-1);
        this.mNativeInfoHandle.recycle();
    }

    public boolean isRecycled() {
        return this.mNativeInfoHandle.isRecycled();
    }

    public void invalidateSelf() {
        super.invalidateSelf();
        this.scheduleNextRender();
    }

    public int getIntrinsicHeight() {
        return this.mScaledHeight;
    }

    public int getIntrinsicWidth() {
        return this.mScaledWidth;
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        if (!this.mNativeInfoHandle.isOpaque() || this.mPaint.getAlpha() < 255) {
            return -2;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        GifDrawable gifDrawable = this;
        synchronized (gifDrawable) {
            if (this.mIsRunning) {
                return;
            }
            this.mIsRunning = true;
        }
        long lastFrameRemainder = this.mNativeInfoHandle.restoreRemainder();
        this.startAnimation(lastFrameRemainder);
    }

    void startAnimation(long lastFrameRemainder) {
        if (this.mIsRenderingTriggeredOnDraw) {
            this.mNextFrameRenderTime = 0L;
            this.mInvalidationHandler.sendEmptyMessageAtTime(-1, 0L);
        } else {
            this.cancelPendingRenderTask();
            this.mRenderTaskSchedule = this.mExecutor.schedule(this.mRenderTask, Math.max(lastFrameRemainder, 0L), TimeUnit.MILLISECONDS);
        }
    }

    public void reset() {
        this.mExecutor.execute(new SafeRunnable(this){

            @Override
            public void doWork() {
                if (GifDrawable.this.mNativeInfoHandle.reset()) {
                    GifDrawable.this.start();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        GifDrawable gifDrawable = this;
        synchronized (gifDrawable) {
            if (!this.mIsRunning) {
                return;
            }
            this.mIsRunning = false;
        }
        this.cancelPendingRenderTask();
        this.mNativeInfoHandle.saveRemainder();
    }

    private void cancelPendingRenderTask() {
        if (this.mRenderTaskSchedule != null) {
            this.mRenderTaskSchedule.cancel(false);
        }
        this.mInvalidationHandler.removeMessages(-1);
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    @Nullable
    public String getComment() {
        return this.mNativeInfoHandle.getComment();
    }

    public int getLoopCount() {
        return this.mNativeInfoHandle.getLoopCount();
    }

    public void setLoopCount(@IntRange(from=0L, to=65535L) int loopCount) {
        this.mNativeInfoHandle.setLoopCount(loopCount);
    }

    @NonNull
    public String toString() {
        return String.format(Locale.ENGLISH, "GIF: size: %dx%d, frames: %d, error: %d", this.mNativeInfoHandle.getWidth(), this.mNativeInfoHandle.getHeight(), this.mNativeInfoHandle.getNumberOfFrames(), this.mNativeInfoHandle.getNativeErrorCode());
    }

    public int getNumberOfFrames() {
        return this.mNativeInfoHandle.getNumberOfFrames();
    }

    @NonNull
    public GifError getError() {
        return GifError.fromCode(this.mNativeInfoHandle.getNativeErrorCode());
    }

    @Nullable
    public static GifDrawable createFromResource(@NonNull Resources res, @RawRes @DrawableRes int resourceId) {
        try {
            return new GifDrawable(res, resourceId);
        }
        catch (IOException ignored) {
            return null;
        }
    }

    public void setSpeed(@FloatRange(from=0.0, fromInclusive=false) float factor) {
        this.mNativeInfoHandle.setSpeedFactor(factor);
    }

    public void pause() {
        this.stop();
    }

    public int getDuration() {
        return this.mNativeInfoHandle.getDuration();
    }

    public int getCurrentPosition() {
        return this.mNativeInfoHandle.getCurrentPosition();
    }

    public void seekTo(final @IntRange(from=0L, to=0x7FFFFFFFL) int position) {
        if (position < 0) {
            throw new IllegalArgumentException("Position is not positive");
        }
        this.mExecutor.execute(new SafeRunnable(this){

            @Override
            public void doWork() {
                GifDrawable.this.mNativeInfoHandle.seekToTime(position, GifDrawable.this.mBuffer);
                this.mGifDrawable.mInvalidationHandler.sendEmptyMessageAtTime(-1, 0L);
            }
        });
    }

    public void seekToFrame(final @IntRange(from=0L, to=0x7FFFFFFFL) int frameIndex) {
        if (frameIndex < 0) {
            throw new IndexOutOfBoundsException("Frame index is not positive");
        }
        this.mExecutor.execute(new SafeRunnable(this){

            @Override
            public void doWork() {
                GifDrawable.this.mNativeInfoHandle.seekToFrame(frameIndex, GifDrawable.this.mBuffer);
                GifDrawable.this.mInvalidationHandler.sendEmptyMessageAtTime(-1, 0L);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap seekToFrameAndGet(@IntRange(from=0L, to=0x7FFFFFFFL) int frameIndex) {
        Bitmap bitmap;
        if (frameIndex < 0) {
            throw new IndexOutOfBoundsException("Frame index is not positive");
        }
        GifInfoHandle gifInfoHandle = this.mNativeInfoHandle;
        synchronized (gifInfoHandle) {
            this.mNativeInfoHandle.seekToFrame(frameIndex, this.mBuffer);
            bitmap = this.getCurrentFrame();
        }
        this.mInvalidationHandler.sendEmptyMessageAtTime(-1, 0L);
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap seekToPositionAndGet(@IntRange(from=0L, to=0x7FFFFFFFL) int position) {
        Bitmap bitmap;
        if (position < 0) {
            throw new IllegalArgumentException("Position is not positive");
        }
        GifInfoHandle gifInfoHandle = this.mNativeInfoHandle;
        synchronized (gifInfoHandle) {
            this.mNativeInfoHandle.seekToTime(position, this.mBuffer);
            bitmap = this.getCurrentFrame();
        }
        this.mInvalidationHandler.sendEmptyMessageAtTime(-1, 0L);
        return bitmap;
    }

    public boolean isPlaying() {
        return this.mIsRunning;
    }

    public int getBufferPercentage() {
        return 100;
    }

    public boolean canPause() {
        return true;
    }

    public boolean canSeekBackward() {
        return this.getNumberOfFrames() > 1;
    }

    public boolean canSeekForward() {
        return this.getNumberOfFrames() > 1;
    }

    public int getAudioSessionId() {
        return 0;
    }

    public int getFrameByteCount() {
        return this.mBuffer.getRowBytes() * this.mBuffer.getHeight();
    }

    public long getAllocationByteCount() {
        long byteCount = this.mNativeInfoHandle.getAllocationByteCount();
        byteCount = Build.VERSION.SDK_INT >= 19 ? (byteCount += (long)this.mBuffer.getAllocationByteCount()) : (byteCount += (long)this.getFrameByteCount());
        return byteCount;
    }

    public long getMetadataAllocationByteCount() {
        return this.mNativeInfoHandle.getMetadataByteCount();
    }

    public long getInputSourceByteCount() {
        return this.mNativeInfoHandle.getSourceLength();
    }

    public void getPixels(@NonNull int[] pixels) {
        this.mBuffer.getPixels(pixels, 0, this.mNativeInfoHandle.getWidth(), 0, 0, this.mNativeInfoHandle.getWidth(), this.mNativeInfoHandle.getHeight());
    }

    public int getPixel(@IntRange(from=0L) int x, @IntRange(from=0L) int y) {
        if (x >= this.mNativeInfoHandle.getWidth()) {
            throw new IllegalArgumentException("x must be < width");
        }
        if (y >= this.mNativeInfoHandle.getHeight()) {
            throw new IllegalArgumentException("y must be < height");
        }
        return this.mBuffer.getPixel(x, y);
    }

    protected void onBoundsChange(Rect bounds) {
        this.mDstRect.set(bounds);
        if (this.mTransform != null) {
            this.mTransform.onBoundsChange(bounds);
        }
    }

    public void draw(@NonNull Canvas canvas) {
        boolean clearColorFilter;
        if (this.mTintFilter != null && this.mPaint.getColorFilter() == null) {
            this.mPaint.setColorFilter((ColorFilter)this.mTintFilter);
            clearColorFilter = true;
        } else {
            clearColorFilter = false;
        }
        if (this.mTransform == null) {
            canvas.drawBitmap(this.mBuffer, this.mSrcRect, this.mDstRect, this.mPaint);
        } else {
            this.mTransform.onDraw(canvas, this.mPaint, this.mBuffer);
        }
        if (clearColorFilter) {
            this.mPaint.setColorFilter(null);
        }
    }

    private void scheduleNextRender() {
        if (this.mIsRenderingTriggeredOnDraw && this.mIsRunning && this.mNextFrameRenderTime != Long.MIN_VALUE) {
            long renderDelay = Math.max(0L, this.mNextFrameRenderTime - SystemClock.uptimeMillis());
            this.mNextFrameRenderTime = Long.MIN_VALUE;
            this.mExecutor.remove(this.mRenderTask);
            this.mRenderTaskSchedule = this.mExecutor.schedule(this.mRenderTask, renderDelay, TimeUnit.MILLISECONDS);
        }
    }

    @NonNull
    public final Paint getPaint() {
        return this.mPaint;
    }

    public int getAlpha() {
        return this.mPaint.getAlpha();
    }

    public void setFilterBitmap(boolean filter) {
        this.mPaint.setFilterBitmap(filter);
        this.invalidateSelf();
    }

    @Deprecated
    public void setDither(boolean dither) {
        this.mPaint.setDither(dither);
        this.invalidateSelf();
    }

    public void addAnimationListener(@NonNull AnimationListener listener) {
        this.mListeners.add(listener);
    }

    public boolean removeAnimationListener(AnimationListener listener) {
        return this.mListeners.remove(listener);
    }

    public ColorFilter getColorFilter() {
        return this.mPaint.getColorFilter();
    }

    public Bitmap getCurrentFrame() {
        Bitmap copy = this.mBuffer.copy(this.mBuffer.getConfig(), this.mBuffer.isMutable());
        copy.setHasAlpha(this.mBuffer.hasAlpha());
        return copy;
    }

    private PorterDuffColorFilter updateTintFilter(ColorStateList tint, PorterDuff.Mode tintMode) {
        if (tint == null || tintMode == null) {
            return null;
        }
        int color = tint.getColorForState(this.getState(), 0);
        return new PorterDuffColorFilter(color, tintMode);
    }

    public void setTintList(ColorStateList tint) {
        this.mTint = tint;
        this.mTintFilter = this.updateTintFilter(tint, this.mTintMode);
        this.invalidateSelf();
    }

    public void setTintMode(@NonNull PorterDuff.Mode tintMode) {
        this.mTintMode = tintMode;
        this.mTintFilter = this.updateTintFilter(this.mTint, tintMode);
        this.invalidateSelf();
    }

    protected boolean onStateChange(int[] stateSet) {
        if (this.mTint != null && this.mTintMode != null) {
            this.mTintFilter = this.updateTintFilter(this.mTint, this.mTintMode);
            return true;
        }
        return false;
    }

    public boolean isStateful() {
        return super.isStateful() || this.mTint != null && this.mTint.isStateful();
    }

    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (!this.mIsRenderingTriggeredOnDraw) {
            if (visible) {
                if (restart) {
                    this.reset();
                }
                if (changed) {
                    this.start();
                }
            } else if (changed) {
                this.stop();
            }
        }
        return changed;
    }

    public int getCurrentFrameIndex() {
        return this.mNativeInfoHandle.getCurrentFrameIndex();
    }

    public int getCurrentLoop() {
        int currentLoop = this.mNativeInfoHandle.getCurrentLoop();
        if (currentLoop == 0 || currentLoop < this.mNativeInfoHandle.getLoopCount()) {
            return currentLoop;
        }
        return currentLoop - 1;
    }

    public boolean isAnimationCompleted() {
        return this.mNativeInfoHandle.isAnimationCompleted();
    }

    public int getFrameDuration(@IntRange(from=0L) int index) {
        return this.mNativeInfoHandle.getFrameDuration(index);
    }

    public void setCornerRadius(@FloatRange(from=0.0) float cornerRadius) {
        this.mTransform = new CornerRadiusTransform(cornerRadius);
        this.mTransform.onBoundsChange(this.mDstRect);
    }

    @FloatRange(from=0.0)
    public float getCornerRadius() {
        if (this.mTransform instanceof CornerRadiusTransform) {
            return ((CornerRadiusTransform)this.mTransform).getCornerRadius();
        }
        return 0.0f;
    }

    public void setTransform(@Nullable Transform transform) {
        this.mTransform = transform;
        if (this.mTransform != null) {
            this.mTransform.onBoundsChange(this.mDstRect);
        }
    }

    @Nullable
    public Transform getTransform() {
        return this.mTransform;
    }
}

