/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.net.Uri;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RawRes;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import pl.droidsonroids.gif.GifDrawable;
import pl.droidsonroids.gif.GifIOException;
import pl.droidsonroids.gif.GifInfoHandle;
import pl.droidsonroids.gif.GifOptions;

public abstract class InputSource {
    private InputSource() {
    }

    abstract GifInfoHandle open() throws IOException;

    final GifDrawable build(GifDrawable oldDrawable, ScheduledThreadPoolExecutor executor, boolean isRenderingAlwaysEnabled, GifOptions options) throws IOException {
        return new GifDrawable(this.createHandleWith(options), oldDrawable, executor, isRenderingAlwaysEnabled);
    }

    final GifInfoHandle createHandleWith(@NonNull GifOptions options) throws IOException {
        GifInfoHandle handle = this.open();
        handle.setOptions(options.inSampleSize, options.inIsOpaque);
        return handle;
    }

    public static class AssetFileDescriptorSource
    extends InputSource {
        private final AssetFileDescriptor mAssetFileDescriptor;

        public AssetFileDescriptorSource(@NonNull AssetFileDescriptor assetFileDescriptor) {
            this.mAssetFileDescriptor = assetFileDescriptor;
        }

        @Override
        GifInfoHandle open() throws IOException {
            return new GifInfoHandle(this.mAssetFileDescriptor);
        }
    }

    public static class ResourcesSource
    extends InputSource {
        private final Resources mResources;
        private final int mResourceId;

        public ResourcesSource(@NonNull Resources resources, @RawRes @DrawableRes int resourceId) {
            this.mResources = resources;
            this.mResourceId = resourceId;
        }

        @Override
        GifInfoHandle open() throws IOException {
            return new GifInfoHandle(this.mResources.openRawResourceFd(this.mResourceId));
        }
    }

    public static final class InputStreamSource
    extends InputSource {
        private final InputStream inputStream;

        public InputStreamSource(@NonNull InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        GifInfoHandle open() throws IOException {
            return new GifInfoHandle(this.inputStream);
        }
    }

    public static final class FileDescriptorSource
    extends InputSource {
        private final FileDescriptor mFd;

        public FileDescriptorSource(@NonNull FileDescriptor fileDescriptor) {
            this.mFd = fileDescriptor;
        }

        @Override
        GifInfoHandle open() throws IOException {
            return new GifInfoHandle(this.mFd);
        }
    }

    public static final class AssetSource
    extends InputSource {
        private final AssetManager mAssetManager;
        private final String mAssetName;

        public AssetSource(@NonNull AssetManager assetManager, @NonNull String assetName) {
            this.mAssetManager = assetManager;
            this.mAssetName = assetName;
        }

        @Override
        GifInfoHandle open() throws IOException {
            return new GifInfoHandle(this.mAssetManager.openFd(this.mAssetName));
        }
    }

    public static final class UriSource
    extends InputSource {
        private final ContentResolver mContentResolver;
        private final Uri mUri;

        public UriSource(@Nullable ContentResolver contentResolver, @NonNull Uri uri) {
            this.mContentResolver = contentResolver;
            this.mUri = uri;
        }

        @Override
        GifInfoHandle open() throws IOException {
            return GifInfoHandle.openUri(this.mContentResolver, this.mUri);
        }
    }

    public static final class FileSource
    extends InputSource {
        private final String mPath;

        public FileSource(@NonNull File file) {
            this.mPath = file.getPath();
        }

        public FileSource(@NonNull String filePath) {
            this.mPath = filePath;
        }

        @Override
        GifInfoHandle open() throws GifIOException {
            return new GifInfoHandle(this.mPath);
        }
    }

    public static final class ByteArraySource
    extends InputSource {
        private final byte[] bytes;

        public ByteArraySource(@NonNull byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        GifInfoHandle open() throws GifIOException {
            return new GifInfoHandle(this.bytes);
        }
    }

    public static final class DirectByteBufferSource
    extends InputSource {
        private final ByteBuffer byteBuffer;

        public DirectByteBufferSource(@NonNull ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
        }

        @Override
        GifInfoHandle open() throws GifIOException {
            return new GifInfoHandle(this.byteBuffer);
        }
    }
}

