/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.system.ErrnoException;
import android.system.Os;
import android.view.Surface;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.RequiresApi;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import pl.droidsonroids.gif.GifError;
import pl.droidsonroids.gif.GifIOException;
import pl.droidsonroids.gif.LibraryLoader;

final class GifInfoHandle {
    private volatile long gifInfoPtr;

    GifInfoHandle() {
    }

    GifInfoHandle(FileDescriptor fileDescriptor) throws GifIOException {
        this.gifInfoPtr = GifInfoHandle.openFileDescriptor(fileDescriptor, 0L, true);
    }

    GifInfoHandle(byte[] bytes) throws GifIOException {
        this.gifInfoPtr = GifInfoHandle.openByteArray(bytes);
    }

    GifInfoHandle(ByteBuffer buffer) throws GifIOException {
        this.gifInfoPtr = GifInfoHandle.openDirectByteBuffer(buffer);
    }

    GifInfoHandle(String filePath) throws GifIOException {
        this.gifInfoPtr = GifInfoHandle.openFile(filePath);
    }

    GifInfoHandle(InputStream stream) throws GifIOException {
        if (!stream.markSupported()) {
            throw new IllegalArgumentException("InputStream does not support marking");
        }
        this.gifInfoPtr = GifInfoHandle.openStream(stream);
    }

    GifInfoHandle(AssetFileDescriptor afd) throws IOException {
        try {
            this.gifInfoPtr = GifInfoHandle.openFileDescriptor(afd.getFileDescriptor(), afd.getStartOffset(), false);
        }
        finally {
            try {
                afd.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static long openFileDescriptor(FileDescriptor fileDescriptor, long offset, boolean closeOriginalDescriptor) throws GifIOException {
        int nativeFileDescriptor;
        if (Build.VERSION.SDK_INT > 27) {
            try {
                nativeFileDescriptor = GifInfoHandle.getNativeFileDescriptor(fileDescriptor, closeOriginalDescriptor);
            }
            catch (Exception e) {
                throw new GifIOException(GifError.OPEN_FAILED.errorCode, e.getMessage());
            }
        } else {
            nativeFileDescriptor = GifInfoHandle.extractNativeFileDescriptor(fileDescriptor, closeOriginalDescriptor);
        }
        return GifInfoHandle.openNativeFileDescriptor(nativeFileDescriptor, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=21)
    private static int getNativeFileDescriptor(FileDescriptor fileDescriptor, boolean closeOriginalDescriptor) throws GifIOException, ErrnoException {
        try {
            int nativeFileDescriptor = GifInfoHandle.createTempNativeFileDescriptor();
            Os.dup2((FileDescriptor)fileDescriptor, (int)nativeFileDescriptor);
            int n = nativeFileDescriptor;
            return n;
        }
        finally {
            if (closeOriginalDescriptor) {
                Os.close((FileDescriptor)fileDescriptor);
            }
        }
    }

    static GifInfoHandle openUri(ContentResolver resolver, Uri uri) throws IOException {
        if ("file".equals(uri.getScheme())) {
            return new GifInfoHandle(uri.getPath());
        }
        AssetFileDescriptor assetFileDescriptor = resolver.openAssetFileDescriptor(uri, "r");
        if (assetFileDescriptor == null) {
            throw new IOException("Could not open AssetFileDescriptor for " + uri);
        }
        return new GifInfoHandle(assetFileDescriptor);
    }

    static native long openNativeFileDescriptor(int var0, long var1) throws GifIOException;

    static native int extractNativeFileDescriptor(FileDescriptor var0, boolean var1) throws GifIOException;

    static native int createTempNativeFileDescriptor() throws GifIOException;

    static native long openByteArray(byte[] var0) throws GifIOException;

    static native long openDirectByteBuffer(ByteBuffer var0) throws GifIOException;

    static native long openStream(InputStream var0) throws GifIOException;

    static native long openFile(String var0) throws GifIOException;

    private static native long renderFrame(long var0, Bitmap var2);

    private static native void bindSurface(long var0, Surface var2, long[] var3);

    private static native void free(long var0);

    private static native boolean reset(long var0);

    private static native void setSpeedFactor(long var0, float var2);

    private static native String getComment(long var0);

    private static native int getLoopCount(long var0);

    private static native void setLoopCount(long var0, char var2);

    private static native long getSourceLength(long var0);

    private static native int getDuration(long var0);

    private static native int getCurrentPosition(long var0);

    private static native void seekToTime(long var0, int var2, Bitmap var3);

    private static native void seekToFrame(long var0, int var2, Bitmap var3);

    private static native void saveRemainder(long var0);

    private static native long restoreRemainder(long var0);

    private static native long getAllocationByteCount(long var0);

    private static native long getMetadataByteCount(long var0);

    private static native int getNativeErrorCode(long var0);

    private static native int getCurrentFrameIndex(long var0);

    private static native int getCurrentLoop(long var0);

    private static native void postUnbindSurface(long var0);

    private static native boolean isAnimationCompleted(long var0);

    private static native long[] getSavedState(long var0);

    private static native int restoreSavedState(long var0, long[] var2, Bitmap var3);

    private static native int getFrameDuration(long var0, int var2);

    private static native void setOptions(long var0, char var2, boolean var3);

    private static native int getWidth(long var0);

    private static native int getHeight(long var0);

    private static native int getNumberOfFrames(long var0);

    private static native boolean isOpaque(long var0);

    private static native void startDecoderThread(long var0);

    private static native void stopDecoderThread(long var0);

    private static native void glTexImage2D(long var0, int var2, int var3);

    private static native void glTexSubImage2D(long var0, int var2, int var3);

    private static native void seekToFrameGL(long var0, int var2);

    private static native void initTexImageDescriptor(long var0);

    synchronized long renderFrame(Bitmap frameBuffer) {
        return GifInfoHandle.renderFrame(this.gifInfoPtr, frameBuffer);
    }

    void bindSurface(Surface surface, long[] savedState) {
        GifInfoHandle.bindSurface(this.gifInfoPtr, surface, savedState);
    }

    synchronized void recycle() {
        GifInfoHandle.free(this.gifInfoPtr);
        this.gifInfoPtr = 0L;
    }

    synchronized long restoreRemainder() {
        return GifInfoHandle.restoreRemainder(this.gifInfoPtr);
    }

    synchronized boolean reset() {
        return GifInfoHandle.reset(this.gifInfoPtr);
    }

    synchronized void saveRemainder() {
        GifInfoHandle.saveRemainder(this.gifInfoPtr);
    }

    synchronized String getComment() {
        return GifInfoHandle.getComment(this.gifInfoPtr);
    }

    synchronized int getLoopCount() {
        return GifInfoHandle.getLoopCount(this.gifInfoPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLoopCount(@IntRange(from=0L, to=65535L) int loopCount) {
        if (loopCount < 0 || loopCount > 65535) {
            throw new IllegalArgumentException("Loop count of range <0, 65535>");
        }
        GifInfoHandle gifInfoHandle = this;
        synchronized (gifInfoHandle) {
            GifInfoHandle.setLoopCount(this.gifInfoPtr, (char)loopCount);
        }
    }

    synchronized long getSourceLength() {
        return GifInfoHandle.getSourceLength(this.gifInfoPtr);
    }

    synchronized int getNativeErrorCode() {
        return GifInfoHandle.getNativeErrorCode(this.gifInfoPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSpeedFactor(@FloatRange(from=0.0, fromInclusive=false) float factor) {
        if (factor <= 0.0f || Float.isNaN(factor)) {
            throw new IllegalArgumentException("Speed factor is not positive");
        }
        if (factor < 4.656613E-10f) {
            factor = 4.656613E-10f;
        }
        GifInfoHandle gifInfoHandle = this;
        synchronized (gifInfoHandle) {
            GifInfoHandle.setSpeedFactor(this.gifInfoPtr, factor);
        }
    }

    synchronized int getDuration() {
        return GifInfoHandle.getDuration(this.gifInfoPtr);
    }

    synchronized int getCurrentPosition() {
        return GifInfoHandle.getCurrentPosition(this.gifInfoPtr);
    }

    synchronized int getCurrentFrameIndex() {
        return GifInfoHandle.getCurrentFrameIndex(this.gifInfoPtr);
    }

    synchronized int getCurrentLoop() {
        return GifInfoHandle.getCurrentLoop(this.gifInfoPtr);
    }

    synchronized void seekToTime(@IntRange(from=0L, to=0x7FFFFFFFL) int position, Bitmap buffer) {
        GifInfoHandle.seekToTime(this.gifInfoPtr, position, buffer);
    }

    synchronized void seekToFrame(@IntRange(from=0L, to=0x7FFFFFFFL) int frameIndex, Bitmap buffer) {
        GifInfoHandle.seekToFrame(this.gifInfoPtr, frameIndex, buffer);
    }

    synchronized long getAllocationByteCount() {
        return GifInfoHandle.getAllocationByteCount(this.gifInfoPtr);
    }

    synchronized long getMetadataByteCount() {
        return GifInfoHandle.getMetadataByteCount(this.gifInfoPtr);
    }

    synchronized boolean isRecycled() {
        return this.gifInfoPtr == 0L;
    }

    protected void finalize() throws Throwable {
        try {
            this.recycle();
        }
        finally {
            super.finalize();
        }
    }

    synchronized void postUnbindSurface() {
        GifInfoHandle.postUnbindSurface(this.gifInfoPtr);
    }

    synchronized boolean isAnimationCompleted() {
        return GifInfoHandle.isAnimationCompleted(this.gifInfoPtr);
    }

    synchronized long[] getSavedState() {
        return GifInfoHandle.getSavedState(this.gifInfoPtr);
    }

    synchronized int restoreSavedState(long[] savedState, Bitmap mBuffer) {
        return GifInfoHandle.restoreSavedState(this.gifInfoPtr, savedState, mBuffer);
    }

    synchronized int getFrameDuration(@IntRange(from=0L) int index) {
        this.throwIfFrameIndexOutOfBounds(index);
        return GifInfoHandle.getFrameDuration(this.gifInfoPtr, index);
    }

    void setOptions(char sampleSize, boolean isOpaque) {
        GifInfoHandle.setOptions(this.gifInfoPtr, sampleSize, isOpaque);
    }

    synchronized int getWidth() {
        return GifInfoHandle.getWidth(this.gifInfoPtr);
    }

    synchronized int getHeight() {
        return GifInfoHandle.getHeight(this.gifInfoPtr);
    }

    synchronized int getNumberOfFrames() {
        return GifInfoHandle.getNumberOfFrames(this.gifInfoPtr);
    }

    synchronized boolean isOpaque() {
        return GifInfoHandle.isOpaque(this.gifInfoPtr);
    }

    void glTexImage2D(int target, int level) {
        GifInfoHandle.glTexImage2D(this.gifInfoPtr, target, level);
    }

    void glTexSubImage2D(int target, int level) {
        GifInfoHandle.glTexSubImage2D(this.gifInfoPtr, target, level);
    }

    void startDecoderThread() {
        GifInfoHandle.startDecoderThread(this.gifInfoPtr);
    }

    void stopDecoderThread() {
        GifInfoHandle.stopDecoderThread(this.gifInfoPtr);
    }

    void initTexImageDescriptor() {
        GifInfoHandle.initTexImageDescriptor(this.gifInfoPtr);
    }

    void seekToFrameGL(@IntRange(from=0L) int index) {
        this.throwIfFrameIndexOutOfBounds(index);
        GifInfoHandle.seekToFrameGL(this.gifInfoPtr, index);
    }

    private void throwIfFrameIndexOutOfBounds(@IntRange(from=0L) int index) {
        int numberOfFrames = GifInfoHandle.getNumberOfFrames(this.gifInfoPtr);
        if (index < 0 || index >= numberOfFrames) {
            throw new IndexOutOfBoundsException("Frame index is not in range <0;" + numberOfFrames + '>');
        }
    }

    static {
        LibraryLoader.loadLibrary();
    }
}

