/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.RawRes;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.widget.ImageView;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import pl.droidsonroids.gif.GifDrawable;
import pl.droidsonroids.gif.R;

final class GifViewUtils {
    static final String ANDROID_NS = "http://schemas.android.com/apk/res/android";
    static final List<String> SUPPORTED_RESOURCE_TYPE_NAMES = Arrays.asList("raw", "drawable", "mipmap");

    private GifViewUtils() {
    }

    static GifImageViewAttributes initImageView(ImageView view, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (attrs != null && !view.isInEditMode()) {
            GifImageViewAttributes viewAttributes = new GifImageViewAttributes(view, attrs, defStyleAttr, defStyleRes);
            int loopCount = viewAttributes.mLoopCount;
            if (loopCount >= 0) {
                GifViewUtils.applyLoopCount(loopCount, view.getDrawable());
                GifViewUtils.applyLoopCount(loopCount, view.getBackground());
            }
            return viewAttributes;
        }
        return new GifImageViewAttributes();
    }

    static void applyLoopCount(int loopCount, Drawable drawable) {
        if (drawable instanceof GifDrawable) {
            ((GifDrawable)drawable).setLoopCount(loopCount);
        }
    }

    static boolean setResource(ImageView view, boolean isSrc, int resId) {
        Resources res = view.getResources();
        if (res != null) {
            try {
                GifDrawable d = new GifDrawable(res, resId);
                if (isSrc) {
                    view.setImageDrawable((Drawable)d);
                } else if (Build.VERSION.SDK_INT >= 16) {
                    view.setBackground((Drawable)d);
                } else {
                    view.setBackgroundDrawable((Drawable)d);
                }
                return true;
            }
            catch (Resources.NotFoundException | IOException throwable) {
                // empty catch block
            }
        }
        return false;
    }

    static boolean setGifImageUri(ImageView imageView, Uri uri) {
        if (uri != null) {
            try {
                imageView.setImageDrawable((Drawable)new GifDrawable(imageView.getContext().getContentResolver(), uri));
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    static float getDensityScale(@NonNull Resources res, @DrawableRes @RawRes int id) {
        TypedValue value = new TypedValue();
        res.getValue(id, value, true);
        int resourceDensity = value.density;
        int density = resourceDensity == 0 ? 160 : (resourceDensity != 65535 ? resourceDensity : 0);
        int targetDensity = res.getDisplayMetrics().densityDpi;
        if (density > 0 && targetDensity > 0) {
            return (float)targetDensity / (float)density;
        }
        return 1.0f;
    }

    static class GifImageViewAttributes
    extends GifViewAttributes {
        final int mSourceResId;
        final int mBackgroundResId;

        GifImageViewAttributes(ImageView view, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            super((View)view, attrs, defStyleAttr, defStyleRes);
            this.mSourceResId = GifImageViewAttributes.getResourceId(view, attrs, true);
            this.mBackgroundResId = GifImageViewAttributes.getResourceId(view, attrs, false);
        }

        GifImageViewAttributes() {
            this.mSourceResId = 0;
            this.mBackgroundResId = 0;
        }

        private static int getResourceId(ImageView view, AttributeSet attrs, boolean isSrc) {
            String resourceTypeName;
            int resId = attrs.getAttributeResourceValue(GifViewUtils.ANDROID_NS, isSrc ? "src" : "background", 0);
            if (resId > 0 && SUPPORTED_RESOURCE_TYPE_NAMES.contains(resourceTypeName = view.getResources().getResourceTypeName(resId)) && !GifViewUtils.setResource(view, isSrc, resId)) {
                return resId;
            }
            return 0;
        }
    }

    static class GifViewAttributes {
        boolean freezesAnimation;
        int mLoopCount;

        GifViewAttributes(View view, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            TypedArray gifViewAttributes = view.getContext().obtainStyledAttributes(attrs, R.styleable.GifView, defStyleAttr, defStyleRes);
            this.freezesAnimation = gifViewAttributes.getBoolean(R.styleable.GifView_freezesAnimation, false);
            this.mLoopCount = gifViewAttributes.getInt(R.styleable.GifView_loopCount, -1);
            gifViewAttributes.recycle();
        }

        GifViewAttributes() {
            this.freezesAnimation = false;
            this.mLoopCount = -1;
        }
    }
}

