/*
 * Decompiled with CFR 0.152.
 */
package pl.gdela.socomo.maven;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.gdela.socomo.SocomoFacade;

abstract class SocomoMojo
extends AbstractMojo {
    private static final Logger log = LoggerFactory.getLogger(SocomoMojo.class);
    @Parameter(property="socomo.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private File bytecodeDirectory;
    @Parameter(property="socomo.level")
    private String level;
    @Component
    private MavenProject mavenProject;
    SocomoFacade socomo;

    SocomoMojo() {
    }

    public final void execute() throws MojoExecutionException {
        if (this.mavenProject.getPackaging().equals("pom")) {
            return;
        }
        if (this.skip) {
            log.warn("skipping socomo");
            return;
        }
        if (!this.bytecodeDirectory.exists()) {
            log.warn("bytecode directory {}", (Object)this.bytecodeDirectory);
            log.warn("skipping socomo in this module, the bytecode directory is missing");
            return;
        }
        File outputHtmlFile = new File(this.mavenProject.getBasedir(), "socomo.html");
        File outputDataFile = new File(this.mavenProject.getBuild().getDirectory(), "socomo.data");
        try {
            this.beforeExecute();
            this.socomo = new SocomoFacade(this.mavenProject.getName());
            this.socomo.analyzeBytecode(this.bytecodeDirectory);
            if (StringUtils.isNotBlank((CharSequence)this.level)) {
                this.socomo.chooseLevel(this.level);
            } else {
                this.socomo.guessLevel();
            }
            this.socomo.visualizeInto(outputHtmlFile, outputDataFile);
            this.afterExecute();
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    abstract void beforeExecute();

    abstract void afterExecute();
}

