/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.propertiestojson;

import java.util.ArrayList;
import java.util.List;

public class PropertyArrayHelper {
    private List<Integer> dimensionalIndexes;
    private String arrayFieldName;

    public PropertyArrayHelper(String field) {
        this.arrayFieldName = PropertyArrayHelper.getNameFromArray(field);
        this.dimensionalIndexes = PropertyArrayHelper.getIndexesFromArrayField(field);
    }

    public static String getNameFromArray(String fieldName) {
        return fieldName.replaceFirst("\\s*(\\[\\s*((([1-9]\\d*)|0)|\\*)\\s*]\\s*)+$", "");
    }

    public static List<Integer> getIndexesFromArrayField(String fieldName) {
        String indexesAsText = fieldName.replace(PropertyArrayHelper.getNameFromArray(fieldName), "");
        String[] indexesAsTextArray = indexesAsText.replace("[", "").replace("]", ",").replaceAll("\\s", "").split(",");
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (String indexAsText : indexesAsTextArray) {
            indexes.add(Integer.valueOf(indexAsText));
        }
        return indexes;
    }

    public List<Integer> getDimensionalIndexes() {
        return this.dimensionalIndexes;
    }

    public String getArrayFieldName() {
        return this.arrayFieldName;
    }
}

