/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.propertiestojson.path;

import pl.jalokim.propertiestojson.PropertyArrayHelper;
import pl.jalokim.propertiestojson.object.AbstractJsonType;

public class PathMetadata {
    private static final String NUMBER_PATTERN = "([1-9]\\d*)|0";
    public static final String INDEXES_PATTERN = "\\s*(\\[\\s*((([1-9]\\d*)|0)|\\*)\\s*]\\s*)+";
    private static final String WORD_PATTERN = "(.)*";
    private final String originalPropertyKey;
    private PathMetadata parent;
    private String fieldName;
    private String originalFieldName;
    private PathMetadata child;
    private PropertyArrayHelper propertyArrayHelper;
    private Object rawValue;
    private AbstractJsonType jsonValue;

    public boolean isLeaf() {
        return this.child == null;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public String getCurrentFullPath() {
        return this.parent == null ? this.originalFieldName : this.parent.getCurrentFullPath() + "." + this.originalFieldName;
    }

    public PathMetadata getLeaf() {
        PathMetadata current = this;
        while (current.getChild() != null) {
            current = current.getChild();
        }
        return current;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
        if (fieldName.matches("(.)*\\s*(\\[\\s*((([1-9]\\d*)|0)|\\*)\\s*]\\s*)+")) {
            this.propertyArrayHelper = new PropertyArrayHelper(fieldName);
            this.fieldName = this.propertyArrayHelper.getArrayFieldName();
        }
    }

    public void setRawValue(Object rawValue) {
        if (!this.isLeaf()) {
            throw new RuntimeException("Cannot set value for not leaf: " + this.getCurrentFullPath());
        }
        this.rawValue = rawValue;
    }

    public String getOriginalPropertyKey() {
        return this.originalPropertyKey;
    }

    public PathMetadata getRoot() {
        PathMetadata current = this;
        while (current.getParent() != null) {
            current = current.getParent();
        }
        return current;
    }

    public String getCurrentFullPathWithoutIndexes() {
        String parentFullPath = this.isRoot() ? "" : this.getParent().getCurrentFullPath() + ".";
        return parentFullPath + this.getFieldName();
    }

    public void setJsonValue(AbstractJsonType jsonValue) {
        if (!this.isLeaf()) {
            throw new RuntimeException("Cannot set value for not leaf: " + this.getCurrentFullPath());
        }
        this.jsonValue = jsonValue;
    }

    public AbstractJsonType getJsonValue() {
        return this.jsonValue;
    }

    public String toString() {
        return "field='" + this.fieldName + '\'' + ", rawValue=" + this.rawValue + ", fullPath='" + this.getCurrentFullPath() + '}';
    }

    public boolean isArrayField() {
        return this.propertyArrayHelper != null;
    }

    public PathMetadata(String originalPropertyKey) {
        this.originalPropertyKey = originalPropertyKey;
    }

    public PathMetadata getParent() {
        return this.parent;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getOriginalFieldName() {
        return this.originalFieldName;
    }

    public PathMetadata getChild() {
        return this.child;
    }

    public PropertyArrayHelper getPropertyArrayHelper() {
        return this.propertyArrayHelper;
    }

    public Object getRawValue() {
        return this.rawValue;
    }

    public void setParent(PathMetadata parent) {
        this.parent = parent;
    }

    public void setOriginalFieldName(String originalFieldName) {
        this.originalFieldName = originalFieldName;
    }

    public void setChild(PathMetadata child) {
        this.child = child;
    }

    public void setPropertyArrayHelper(PropertyArrayHelper propertyArrayHelper) {
        this.propertyArrayHelper = propertyArrayHelper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PathMetadata)) {
            return false;
        }
        PathMetadata other = (PathMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$originalPropertyKey = this.getOriginalPropertyKey();
        String other$originalPropertyKey = other.getOriginalPropertyKey();
        if (this$originalPropertyKey == null ? other$originalPropertyKey != null : !this$originalPropertyKey.equals(other$originalPropertyKey)) {
            return false;
        }
        PathMetadata this$parent = this.getParent();
        PathMetadata other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        String this$originalFieldName = this.getOriginalFieldName();
        String other$originalFieldName = other.getOriginalFieldName();
        if (this$originalFieldName == null ? other$originalFieldName != null : !this$originalFieldName.equals(other$originalFieldName)) {
            return false;
        }
        PathMetadata this$child = this.getChild();
        PathMetadata other$child = other.getChild();
        if (this$child == null ? other$child != null : !((Object)this$child).equals(other$child)) {
            return false;
        }
        PropertyArrayHelper this$propertyArrayHelper = this.getPropertyArrayHelper();
        PropertyArrayHelper other$propertyArrayHelper = other.getPropertyArrayHelper();
        if (this$propertyArrayHelper == null ? other$propertyArrayHelper != null : !this$propertyArrayHelper.equals(other$propertyArrayHelper)) {
            return false;
        }
        Object this$rawValue = this.getRawValue();
        Object other$rawValue = other.getRawValue();
        if (this$rawValue == null ? other$rawValue != null : !this$rawValue.equals(other$rawValue)) {
            return false;
        }
        AbstractJsonType this$jsonValue = this.getJsonValue();
        AbstractJsonType other$jsonValue = other.getJsonValue();
        return !(this$jsonValue == null ? other$jsonValue != null : !this$jsonValue.equals(other$jsonValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PathMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $originalPropertyKey = this.getOriginalPropertyKey();
        result = result * 59 + ($originalPropertyKey == null ? 43 : $originalPropertyKey.hashCode());
        PathMetadata $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        String $originalFieldName = this.getOriginalFieldName();
        result = result * 59 + ($originalFieldName == null ? 43 : $originalFieldName.hashCode());
        PathMetadata $child = this.getChild();
        result = result * 59 + ($child == null ? 43 : ((Object)$child).hashCode());
        PropertyArrayHelper $propertyArrayHelper = this.getPropertyArrayHelper();
        result = result * 59 + ($propertyArrayHelper == null ? 43 : $propertyArrayHelper.hashCode());
        Object $rawValue = this.getRawValue();
        result = result * 59 + ($rawValue == null ? 43 : $rawValue.hashCode());
        AbstractJsonType $jsonValue = this.getJsonValue();
        result = result * 59 + ($jsonValue == null ? 43 : $jsonValue.hashCode());
        return result;
    }
}

