/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.propertiestojson.resolvers.hierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import pl.jalokim.propertiestojson.util.ListUtil;
import pl.jalokim.propertiestojson.util.exception.ParsePropertiesException;

public class HierarchyClassResolver {
    private final String ERROR_MSG = "Found %s resolvers for instance type: %s%nfound resolvers:%n%s";
    private final List<Class<?>> resolverClasses;

    public HierarchyClassResolver(List<Class<?>> typesWhichCanResolve) {
        this.resolverClasses = typesWhichCanResolve;
    }

    public Class<?> searchResolverClass(Object instance) {
        if (instance == null) {
            return null;
        }
        Class<?> instanceClass = instance.getClass();
        SearchContext searchContext = new SearchContext();
        for (Class<?> resolverClass : this.resolverClasses) {
            if (!resolverClass.isAssignableFrom(instanceClass)) continue;
            if (!resolverClass.isInterface()) {
                int difference = this.countDifferenceForSuperClass(resolverClass, instanceClass);
                this.addToFoundWhenIsClosetsMatch(searchContext, resolverClass, difference);
            }
            if (!resolverClass.isInterface()) continue;
            this.findDifferenceInSuperClasses(searchContext, resolverClass, instanceClass);
            this.findDifferenceForSuperInterfaces(searchContext, resolverClass, this.getSuperInterfaces(instanceClass));
        }
        if (searchContext.getFoundClasses().isEmpty()) {
            return null;
        }
        if (searchContext.getFoundClasses().size() == 1) {
            return searchContext.getFoundClasses().get(0);
        }
        List<Class<?>> foundClasses = searchContext.getFoundClasses();
        Optional<Class> onlyObjectTypeOpt = foundClasses.stream().filter(type -> !type.isInterface() && !type.isEnum()).findAny();
        if (onlyObjectTypeOpt.isPresent()) {
            if (onlyObjectTypeOpt.get() != Object.class) {
                return onlyObjectTypeOpt.get();
            }
            ArrayList foundInterfaces = new ArrayList(foundClasses);
            foundInterfaces.remove(onlyObjectTypeOpt.get());
            if (foundInterfaces.size() == 1) {
                return (Class)foundInterfaces.get(0);
            }
            foundClasses = foundInterfaces;
        }
        throw new ParsePropertiesException(String.format("Found %s resolvers for instance type: %s%nfound resolvers:%n%s", foundClasses.size(), instance.getClass().getCanonicalName(), ListUtil.everyElementAsNewLine(foundClasses)));
    }

    private void addToFoundWhenIsClosetsMatch(SearchContext searchContext, Class<?> resolverClass, int difference) {
        if (difference < searchContext.getCurrentNearCounter()) {
            searchContext.setCurrentNearCounter(difference);
            searchContext.clear();
            searchContext.add(resolverClass);
        } else if (searchContext.getCurrentNearCounter() == difference) {
            searchContext.add(resolverClass);
        }
    }

    private int countDifferenceForSuperClass(Class<?> resolverClass, Class<?> instanceClass) {
        Class<?> currentClass = instanceClass;
        int counter = 0;
        while (!resolverClass.getCanonicalName().equals(currentClass.getCanonicalName())) {
            currentClass = currentClass.getSuperclass();
            ++counter;
            if (currentClass != null) continue;
            return Integer.MAX_VALUE;
        }
        return counter;
    }

    private void findDifferenceInSuperClasses(SearchContext searchContext, Class<?> resolverClass, Class<?> instanceClass) {
        Class<?> currentClass = instanceClass;
        while (currentClass != null) {
            ++searchContext.searchHierarchyLevel;
            if ((currentClass = currentClass.getSuperclass()) == null) break;
            this.findDifferenceForSuperInterfaces(searchContext, resolverClass, this.getSuperInterfaces(currentClass));
        }
        searchContext.searchHierarchyLevel = 0;
    }

    private void findDifferenceForSuperInterfaces(SearchContext searchContext, Class<?> resolverClass, List<Class<?>> interfaceClasses) {
        ++searchContext.searchHierarchyLevel;
        for (Class<?> interfaceClass : interfaceClasses) {
            List<Class<?>> superInterfaces = this.getSuperInterfaces(interfaceClass);
            if (!superInterfaces.isEmpty()) {
                this.findDifferenceForSuperInterfaces(searchContext, resolverClass, superInterfaces);
            }
            if (!interfaceClass.getCanonicalName().equals(resolverClass.getCanonicalName())) continue;
            this.addToFoundWhenIsClosetsMatch(searchContext, resolverClass, searchContext.searchHierarchyLevel);
        }
        --searchContext.searchHierarchyLevel;
    }

    private List<Class<?>> getSuperInterfaces(Class<?> type) {
        return new ArrayList(Arrays.asList(type.getInterfaces()));
    }

    private static class SearchContext {
        final List<Class<?>> foundClasses = new ArrayList();
        int currentNearCounter = Integer.MAX_VALUE;
        int searchHierarchyLevel = 0;

        public void add(Class<?> type) {
            if (!this.foundClasses.contains(type)) {
                this.foundClasses.add(type);
            }
        }

        public void clear() {
            this.foundClasses.clear();
        }

        public List<Class<?>> getFoundClasses() {
            return this.foundClasses;
        }

        public int getCurrentNearCounter() {
            return this.currentNearCounter;
        }

        public int getSearchHierarchyLevel() {
            return this.searchHierarchyLevel;
        }

        public void setCurrentNearCounter(int currentNearCounter) {
            this.currentNearCounter = currentNearCounter;
        }

        public void setSearchHierarchyLevel(int searchHierarchyLevel) {
            this.searchHierarchyLevel = searchHierarchyLevel;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SearchContext)) {
                return false;
            }
            SearchContext other = (SearchContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Class<?>> this$foundClasses = this.getFoundClasses();
            List<Class<?>> other$foundClasses = other.getFoundClasses();
            if (this$foundClasses == null ? other$foundClasses != null : !((Object)this$foundClasses).equals(other$foundClasses)) {
                return false;
            }
            if (this.getCurrentNearCounter() != other.getCurrentNearCounter()) {
                return false;
            }
            return this.getSearchHierarchyLevel() == other.getSearchHierarchyLevel();
        }

        protected boolean canEqual(Object other) {
            return other instanceof SearchContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Class<?>> $foundClasses = this.getFoundClasses();
            result = result * 59 + ($foundClasses == null ? 43 : ((Object)$foundClasses).hashCode());
            result = result * 59 + this.getCurrentNearCounter();
            result = result * 59 + this.getSearchHierarchyLevel();
            return result;
        }

        public String toString() {
            return "HierarchyClassResolver.SearchContext(foundClasses=" + this.getFoundClasses() + ", currentNearCounter=" + this.getCurrentNearCounter() + ", searchHierarchyLevel=" + this.getSearchHierarchyLevel() + ")";
        }
    }
}

