/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.propertiestojson.resolvers.primitives.string;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import pl.jalokim.propertiestojson.resolvers.PrimitiveJsonTypesResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToConcreteObjectResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.utils.JsonObjectHelper;

public class TextToElementsResolver
implements TextToConcreteObjectResolver<List<?>> {
    private final String arrayElementSeparator;
    private final boolean resolveTypeOfEachElement;

    public TextToElementsResolver() {
        this(true);
    }

    public TextToElementsResolver(boolean resolveTypeOfEachElement) {
        this(resolveTypeOfEachElement, ",");
    }

    public TextToElementsResolver(boolean resolveTypeOfEachElement, String arrayElementSeparator) {
        this.resolveTypeOfEachElement = resolveTypeOfEachElement;
        this.arrayElementSeparator = arrayElementSeparator;
    }

    @Override
    public Optional<List<?>> returnObjectWhenCanBeResolved(PrimitiveJsonTypesResolver primitiveJsonTypesResolver, String propertyValue, String propertyKey) {
        if (this.isSimpleArray(propertyValue) && !JsonObjectHelper.isValidJsonObjectOrArray(propertyValue)) {
            String[] elements;
            if (JsonObjectHelper.hasJsonArraySignature(propertyValue)) {
                propertyValue = propertyValue.replaceAll("]\\s*$", "").replaceAll("^\\s*\\[\\s*", "");
                elements = propertyValue.split(this.arrayElementSeparator);
                ArrayList<String> clearedElements = new ArrayList<String>();
                String[] stringArray = elements;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String element = stringArray[i];
                    element = element.trim();
                    clearedElements.add(element);
                }
                propertyValue = String.join((CharSequence)this.arrayElementSeparator, clearedElements);
            }
            elements = new ArrayList();
            for (String element : propertyValue.split(this.arrayElementSeparator)) {
                if (this.resolveTypeOfEachElement) {
                    elements.add(primitiveJsonTypesResolver.getResolvedObject(element, propertyKey));
                    continue;
                }
                elements.add(element);
            }
            return Optional.of(elements);
        }
        return Optional.empty();
    }

    private boolean isSimpleArray(String propertyValue) {
        return propertyValue.contains(this.arrayElementSeparator) || JsonObjectHelper.hasJsonArraySignature(propertyValue);
    }
}

