/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.propertiestojson.resolvers.primitives.utils;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Map;
import pl.jalokim.propertiestojson.object.AbstractJsonType;
import pl.jalokim.propertiestojson.object.ArrayJsonType;
import pl.jalokim.propertiestojson.object.JsonNullReferenceType;
import pl.jalokim.propertiestojson.object.ObjectJsonType;
import pl.jalokim.propertiestojson.resolvers.PrimitiveJsonTypesResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.object.BooleanToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.object.NullToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.object.NumberToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.object.ObjectToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.object.StringToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToBooleanResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToConcreteObjectResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToNumberResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToStringResolver;

public class JsonObjectHelper {
    private static final PrimitiveJsonTypesResolver primitiveJsonTypesResolver;
    private static final JsonParser jp;
    private static final Gson gson;

    public static String toJson(Object object) {
        return gson.toJson(object);
    }

    public static JsonElement toJsonElement(String json) {
        return jp.parse(json);
    }

    public static ObjectJsonType createObjectJsonType(JsonElement parsedJson, String propertyKey) {
        ObjectJsonType objectJsonType = new ObjectJsonType();
        JsonObject asJsonObject = parsedJson.getAsJsonObject();
        for (Map.Entry entry : asJsonObject.entrySet()) {
            JsonElement someField = (JsonElement)entry.getValue();
            AbstractJsonType valueOfNextField = JsonObjectHelper.convertToAbstractJsonType(someField, propertyKey);
            objectJsonType.addField((String)entry.getKey(), valueOfNextField, null);
        }
        return objectJsonType;
    }

    public static AbstractJsonType convertToAbstractJsonType(JsonElement someField, String propertyKey) {
        AbstractJsonType valueOfNextField = null;
        if (someField.isJsonNull()) {
            valueOfNextField = JsonNullReferenceType.NULL_OBJECT;
        }
        if (someField.isJsonObject()) {
            valueOfNextField = JsonObjectHelper.createObjectJsonType(someField, propertyKey);
        }
        if (someField.isJsonArray()) {
            valueOfNextField = JsonObjectHelper.createArrayJsonType(someField, propertyKey);
        }
        if (someField.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = someField.getAsJsonPrimitive();
            if (jsonPrimitive.isString()) {
                valueOfNextField = primitiveJsonTypesResolver.resolvePrimitiveTypeAndReturn(jsonPrimitive.getAsString(), propertyKey);
            } else if (jsonPrimitive.isNumber()) {
                String numberAsText = jsonPrimitive.getAsNumber().toString();
                valueOfNextField = primitiveJsonTypesResolver.resolvePrimitiveTypeAndReturn(TextToNumberResolver.convertToNumber(numberAsText), propertyKey);
            } else if (jsonPrimitive.isBoolean()) {
                valueOfNextField = primitiveJsonTypesResolver.resolvePrimitiveTypeAndReturn(jsonPrimitive.getAsBoolean(), propertyKey);
            }
        }
        return valueOfNextField;
    }

    public static ArrayJsonType createArrayJsonType(JsonElement parsedJson, String propertyKey) {
        ArrayJsonType arrayJsonType = new ArrayJsonType();
        JsonArray asJsonArray = parsedJson.getAsJsonArray();
        int index = 0;
        for (JsonElement element : asJsonArray) {
            arrayJsonType.addElement(index, JsonObjectHelper.convertToAbstractJsonType(element, propertyKey), null);
            ++index;
        }
        return arrayJsonType;
    }

    public static boolean isValidJsonObjectOrArray(String propertyValue) {
        if (JsonObjectHelper.hasJsonObjectSignature(propertyValue) || JsonObjectHelper.hasJsonArraySignature(propertyValue)) {
            JsonParser jp = new JsonParser();
            try {
                jp.parse(propertyValue);
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    public static boolean hasJsonArraySignature(String propertyValue) {
        return JsonObjectHelper.hasJsonSignature(propertyValue.trim(), "[", "]");
    }

    public static boolean hasJsonObjectSignature(String propertyValue) {
        return JsonObjectHelper.hasJsonSignature(propertyValue.trim(), "{", "}");
    }

    private static boolean hasJsonSignature(String propertyValue, String startSign, String endSign) {
        return JsonObjectHelper.firsLetter(propertyValue).contains(startSign) && JsonObjectHelper.lastLetter(propertyValue).contains(endSign);
    }

    private static String firsLetter(String text) {
        return text.substring(0, 1);
    }

    private static String lastLetter(String text) {
        return text.substring(text.length() - 1);
    }

    static {
        jp = new JsonParser();
        gson = new Gson();
        ArrayList<ObjectToJsonTypeConverter> toJsonResolvers = new ArrayList<ObjectToJsonTypeConverter>();
        toJsonResolvers.add(new NumberToJsonTypeConverter());
        toJsonResolvers.add(new BooleanToJsonTypeConverter());
        toJsonResolvers.add(StringToJsonTypeConverter.STRING_TO_JSON_RESOLVER);
        ArrayList<TextToConcreteObjectResolver> toObjectsResolvers = new ArrayList<TextToConcreteObjectResolver>();
        toObjectsResolvers.add(new TextToNumberResolver());
        toObjectsResolvers.add(new TextToBooleanResolver());
        toObjectsResolvers.add(TextToStringResolver.TO_STRING_RESOLVER);
        primitiveJsonTypesResolver = new PrimitiveJsonTypesResolver(toObjectsResolvers, toJsonResolvers, false, NullToJsonTypeConverter.NULL_TO_JSON_RESOLVER);
    }
}

