/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.propertiestojson.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ReflectionUtils {
    public static void setValue(Object target, String fieldName, Object value) {
        Field field = null;
        ArrayList<String> noSuchFieldExceptions = new ArrayList<String>();
        for (Class<?> currentClass = target.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                field = currentClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                noSuchFieldExceptions.add(e.getMessage());
            }
            if (field != null) break;
        }
        if (field == null) {
            throw new RuntimeException(new NoSuchFieldException(((Object)noSuchFieldExceptions).toString()));
        }
        try {
            field.setAccessible(true);
            field.set(target, value);
            field.setAccessible(false);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T invokeMethod(Object target, String methodName, List<Class<?>> argClasses, List<Object> args) {
        return ReflectionUtils.invokeMethod(target, target.getClass(), methodName, argClasses, args);
    }

    public static <T> T invokeMethod(Object target, Class<?> targetClass, String methodName, List<Class<?>> argClasses, List<Object> args) {
        Method method = null;
        ArrayList<String> noSuchMethodExceptions = new ArrayList<String>();
        for (Class<?> currentClass = targetClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                method = currentClass.getDeclaredMethod(methodName, argClasses.toArray(new Class[0]));
            }
            catch (NoSuchMethodException e) {
                noSuchMethodExceptions.add(e.getMessage());
            }
            if (method != null) break;
        }
        if (method == null) {
            throw new RuntimeException(new NoSuchMethodException(((Object)noSuchMethodExceptions).toString()));
        }
        try {
            method.setAccessible(true);
            Object result = method.invoke(target, args.toArray(new Object[0]));
            method.setAccessible(false);
            return (T)result;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

