/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.propertiestojson;

import java.util.Map;
import pl.jalokim.propertiestojson.AlgorithmType;
import pl.jalokim.propertiestojson.object.AbstractJsonType;
import pl.jalokim.propertiestojson.object.ObjectJsonType;
import pl.jalokim.propertiestojson.object.SkipJsonField;
import pl.jalokim.propertiestojson.path.PathMetadata;
import pl.jalokim.propertiestojson.resolvers.JsonTypeResolver;
import pl.jalokim.propertiestojson.resolvers.PrimitiveJsonTypesResolver;
import pl.jalokim.propertiestojson.resolvers.transfer.DataForResolve;

public class JsonObjectsTraverseResolver {
    private final Map<AlgorithmType, JsonTypeResolver> algorithms;
    private final PrimitiveJsonTypesResolver primitiveJsonTypesResolver;
    private Map<String, Object> properties;
    private String propertyKey;
    private PathMetadata rootPathMetaData;
    private ObjectJsonType currentObjectJsonType;

    public JsonObjectsTraverseResolver(Map<AlgorithmType, JsonTypeResolver> algorithms, Map<String, Object> properties, String propertyKey, PathMetadata rootPathMetaData, ObjectJsonType coreObjectJsonType) {
        this.properties = properties;
        this.propertyKey = propertyKey;
        this.rootPathMetaData = rootPathMetaData;
        this.currentObjectJsonType = coreObjectJsonType;
        this.algorithms = algorithms;
        this.primitiveJsonTypesResolver = (PrimitiveJsonTypesResolver)algorithms.get((Object)AlgorithmType.PRIMITIVE);
    }

    public void initializeFieldsInJson() {
        PathMetadata currentPathMetaData = this.rootPathMetaData;
        Object valueFromProperties = this.properties.get(currentPathMetaData.getOriginalPropertyKey());
        if (valueFromProperties != null && valueFromProperties instanceof SkipJsonField) {
            return;
        }
        AbstractJsonType resolverJsonObject = this.primitiveJsonTypesResolver.resolvePrimitiveTypeAndReturn(valueFromProperties, currentPathMetaData.getOriginalPropertyKey());
        if (resolverJsonObject instanceof SkipJsonField && !this.rootPathMetaData.getLeaf().isArrayField()) {
            return;
        }
        this.rootPathMetaData.getLeaf().setJsonValue(resolverJsonObject);
        this.rootPathMetaData.getLeaf().setRawValue(this.properties.get(this.propertyKey));
        while (currentPathMetaData != null) {
            DataForResolve dataForResolve = new DataForResolve(this.properties, this.propertyKey, this.currentObjectJsonType, currentPathMetaData);
            this.currentObjectJsonType = this.algorithms.get((Object)this.resolveAlgorithm(currentPathMetaData)).traverseOnObjectAndInitByField(dataForResolve);
            currentPathMetaData = currentPathMetaData.getChild();
        }
    }

    private AlgorithmType resolveAlgorithm(PathMetadata currentPathMetaData) {
        if (this.isPrimitiveField(currentPathMetaData)) {
            return AlgorithmType.PRIMITIVE;
        }
        if (currentPathMetaData.isArrayField()) {
            return AlgorithmType.ARRAY;
        }
        return AlgorithmType.OBJECT;
    }

    private boolean isPrimitiveField(PathMetadata currentPathMetaData) {
        return currentPathMetaData.isLeaf();
    }
}

