/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.propertiestojson.object;

import java.util.LinkedHashMap;
import java.util.Map;
import pl.jalokim.propertiestojson.object.AbstractJsonType;
import pl.jalokim.propertiestojson.object.ArrayJsonType;
import pl.jalokim.propertiestojson.object.MergableObject;
import pl.jalokim.propertiestojson.object.SkipJsonField;
import pl.jalokim.propertiestojson.path.PathMetadata;
import pl.jalokim.propertiestojson.util.StringToJsonStringWrapper;
import pl.jalokim.propertiestojson.util.exception.CannotOverrideFieldException;
import pl.jalokim.utils.collection.CollectionUtils;

public class ObjectJsonType
extends AbstractJsonType
implements MergableObject<ObjectJsonType> {
    private Map<String, AbstractJsonType> fields = new LinkedHashMap<String, AbstractJsonType>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addField(String field, AbstractJsonType object, PathMetadata currentPathMetaData) {
        if (object instanceof SkipJsonField) {
            return;
        }
        AbstractJsonType oldFieldValue = this.fields.get(field);
        if (oldFieldValue != null) {
            if (!(oldFieldValue instanceof MergableObject) || !(object instanceof MergableObject)) throw new CannotOverrideFieldException(currentPathMetaData.getCurrentFullPath(), oldFieldValue, currentPathMetaData.getOriginalPropertyKey());
            MergableObject.mergeObjectIfPossible(oldFieldValue, object, currentPathMetaData);
            return;
        } else {
            this.fields.put(field, object);
        }
    }

    public boolean containsField(String field) {
        return this.fields.containsKey(field);
    }

    public AbstractJsonType getField(String field) {
        return this.fields.get(field);
    }

    public ArrayJsonType getJsonArray(String field) {
        return (ArrayJsonType)this.fields.get(field);
    }

    @Override
    public String toStringJson() {
        StringBuilder result = new StringBuilder().append("{");
        int index = 0;
        int lastIndex = CollectionUtils.getLastIndex(this.fields.keySet());
        for (String fieldName : this.fields.keySet()) {
            AbstractJsonType object = this.fields.get(fieldName);
            String lastSign = index == lastIndex ? "" : ",";
            result.append(StringToJsonStringWrapper.wrap(fieldName)).append(":").append(object.toStringJson()).append(lastSign);
            ++index;
        }
        result.append("}");
        return result.toString();
    }

    @Override
    public void merge(ObjectJsonType mergeWith, PathMetadata currentPathMetadata) {
        for (String fieldName : mergeWith.fields.keySet()) {
            this.addField(fieldName, mergeWith.getField(fieldName), currentPathMetadata);
        }
    }
}

