/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.propertiestojson.resolvers.hierarchy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import pl.jalokim.propertiestojson.object.AbstractJsonType;
import pl.jalokim.propertiestojson.resolvers.PrimitiveJsonTypesResolver;
import pl.jalokim.propertiestojson.resolvers.hierarchy.HierarchyClassResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.PrimitiveJsonTypeResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.adapter.PrimitiveJsonTypeResolverToNewApiAdapter;
import pl.jalokim.propertiestojson.resolvers.primitives.object.ObjectToJsonTypeConverter;
import pl.jalokim.propertiestojson.util.exception.ParsePropertiesException;

public class JsonTypeResolversHierarchyResolver {
    private final Map<Class<?>, List<ObjectToJsonTypeConverter<?>>> resolversByType = new HashMap();
    private final HierarchyClassResolver hierarchyClassResolver;

    public JsonTypeResolversHierarchyResolver(List<ObjectToJsonTypeConverter> resolvers) {
        for (ObjectToJsonTypeConverter resolver : resolvers) {
            for (Class<?> canResolveType : resolver.getClassesWhichCanResolve()) {
                List<ObjectToJsonTypeConverter<?>> resolversByClass = this.resolversByType.get(canResolveType);
                if (resolversByClass == null) {
                    ArrayList<ObjectToJsonTypeConverter> newResolvers = new ArrayList<ObjectToJsonTypeConverter>();
                    newResolvers.add(resolver);
                    this.resolversByType.put(canResolveType, newResolvers);
                    continue;
                }
                resolversByClass.add(resolver);
            }
        }
        ArrayList typesWhichCanResolve = new ArrayList();
        for (ObjectToJsonTypeConverter resolver : resolvers) {
            typesWhichCanResolve.addAll(resolver.getClassesWhichCanResolve());
        }
        this.hierarchyClassResolver = new HierarchyClassResolver(typesWhichCanResolve);
    }

    public AbstractJsonType returnConcreteJsonTypeObject(PrimitiveJsonTypesResolver mainResolver, Object instance, String propertyKey) {
        Objects.requireNonNull(instance);
        Class<?> instanceClass = instance.getClass();
        List<ObjectToJsonTypeConverter<?>> resolvers = this.resolversByType.get(instanceClass);
        if (resolvers == null) {
            Class<?> typeWhichCanResolve = this.hierarchyClassResolver.searchResolverClass(instance);
            if (typeWhichCanResolve == null) {
                throw new ParsePropertiesException(String.format("Cannot find valid JSON type resolver for class: '%s'. \nPlease consider add sufficient resolver to your resolvers.", instanceClass));
            }
            resolvers = this.resolversByType.get(typeWhichCanResolve);
        }
        if (!resolvers.isEmpty()) {
            if (instanceClass != String.class && resolvers.size() > 1 && resolvers.stream().anyMatch(resolver -> resolver instanceof PrimitiveJsonTypeResolverToNewApiAdapter)) {
                List resolversClasses = resolvers.stream().map(resolver -> {
                    if (resolver instanceof PrimitiveJsonTypeResolverToNewApiAdapter) {
                        PrimitiveJsonTypeResolverToNewApiAdapter adapter = (PrimitiveJsonTypeResolverToNewApiAdapter)resolver;
                        PrimitiveJsonTypeResolver oldImplementation = adapter.getOldImplementation();
                        return oldImplementation.getClass();
                    }
                    return resolver.getClass();
                }).collect(Collectors.toList());
                throw new ParsePropertiesException("Found: " + new ArrayList(resolversClasses) + " for type" + instanceClass + " expected only one!");
            }
            for (ObjectToJsonTypeConverter<?> resolver2 : resolvers) {
                Optional<AbstractJsonType> abstractJsonType = resolver2.returnOptionalJsonType(mainResolver, instance, propertyKey);
                if (!abstractJsonType.isPresent()) continue;
                return abstractJsonType.get();
            }
        }
        throw new ParsePropertiesException(String.format("Cannot find valid JSON type resolver for class: '%s'. \n for property: %s, and object value: %s \nPlease consider add sufficient resolver to your resolvers.", instanceClass, propertyKey, instance));
    }
}

