/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.propertiestojson.resolvers.primitives.custom;

import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Optional;
import pl.jalokim.propertiestojson.object.AbstractJsonType;
import pl.jalokim.propertiestojson.object.NumberJsonType;
import pl.jalokim.propertiestojson.resolvers.PrimitiveJsonTypesResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.object.AbstractObjectToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.object.SuperObjectToJsonTypeConverter;

public class LocalDateToJsonTypeConverter
extends AbstractObjectToJsonTypeConverter<LocalDate> {
    private final boolean asTimestampInUTC;

    public LocalDateToJsonTypeConverter() {
        this(false);
    }

    public LocalDateToJsonTypeConverter(boolean asTimestampInUTC) {
        this.asTimestampInUTC = asTimestampInUTC;
    }

    @Override
    public Optional<AbstractJsonType> convertToJsonTypeOrEmpty(PrimitiveJsonTypesResolver primitiveJsonTypesResolver, LocalDate convertedValue, String propertyKey) {
        if (this.asTimestampInUTC) {
            return Optional.of(new NumberJsonType(convertedValue.atStartOfDay(ZoneOffset.UTC).toEpochSecond()));
        }
        if (!propertyKey.contains("asText")) {
            return Optional.of(SuperObjectToJsonTypeConverter.convertFromObjectToJson(convertedValue, propertyKey));
        }
        return Optional.empty();
    }
}

