/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.propertiestojson.resolvers.primitives.object;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import pl.jalokim.propertiestojson.object.AbstractJsonType;
import pl.jalokim.propertiestojson.object.ArrayJsonType;
import pl.jalokim.propertiestojson.resolvers.PrimitiveJsonTypesResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.object.AbstractObjectToJsonTypeConverter;

public class ElementsToJsonTypeConverter
extends AbstractObjectToJsonTypeConverter<Collection<?>> {
    @Override
    public Optional<AbstractJsonType> convertToJsonTypeOrEmpty(PrimitiveJsonTypesResolver primitiveJsonTypesResolver, Collection<?> elements, String propertyKey) {
        return Optional.of(new ArrayJsonType(primitiveJsonTypesResolver, elements, null, propertyKey));
    }

    @Override
    public Optional<AbstractJsonType> returnOptionalJsonType(PrimitiveJsonTypesResolver primitiveJsonTypesResolver, Object propertyValue, String propertyKey) {
        if (this.hasElements(propertyValue.getClass())) {
            ArrayList<Object> collection;
            if (propertyValue.getClass().isArray()) {
                Object[] rawArray = (Object[])propertyValue;
                collection = new ArrayList<Object>(Arrays.asList(rawArray));
            } else {
                collection = (ArrayList<Object>)propertyValue;
            }
            return this.convertToJsonTypeOrEmpty(primitiveJsonTypesResolver, (Collection<?>)collection, propertyKey);
        }
        return this.convertToJsonTypeOrEmpty(primitiveJsonTypesResolver, (Collection<?>)Collections.singletonList(propertyValue), propertyKey);
    }

    public boolean hasElements(Class<?> classToTest) {
        return this.canResolveClass.isAssignableFrom(classToTest) || classToTest.isArray();
    }

    @Override
    public Class<?> resolveTypeOfResolver() {
        return Collection.class;
    }

    @Override
    public List<Class<?>> getClassesWhichCanResolve() {
        return Arrays.asList(Collection.class, Object[].class);
    }
}

