/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.propertiestojson.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import pl.jalokim.propertiestojson.AlgorithmType;
import pl.jalokim.propertiestojson.JsonObjectsTraverseResolver;
import pl.jalokim.propertiestojson.helper.PropertiesWithInsertOrder;
import pl.jalokim.propertiestojson.helper.PropertyKeysOrderResolver;
import pl.jalokim.propertiestojson.object.ObjectJsonType;
import pl.jalokim.propertiestojson.path.PathMetadata;
import pl.jalokim.propertiestojson.path.PathMetadataBuilder;
import pl.jalokim.propertiestojson.resolvers.ArrayJsonTypeResolver;
import pl.jalokim.propertiestojson.resolvers.JsonTypeResolver;
import pl.jalokim.propertiestojson.resolvers.ObjectJsonTypeResolver;
import pl.jalokim.propertiestojson.resolvers.PrimitiveJsonTypesResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.PrimitiveJsonTypeResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.StringJsonTypeResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.adapter.PrimitiveJsonTypeResolverToNewApiAdapter;
import pl.jalokim.propertiestojson.resolvers.primitives.object.NullToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.object.ObjectToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.object.StringToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToConcreteObjectResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToEmptyStringResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToJsonNullReferenceResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToStringResolver;
import pl.jalokim.propertiestojson.util.PropertiesToJsonConverterBuilder;
import pl.jalokim.propertiestojson.util.exception.ParsePropertiesException;
import pl.jalokim.propertiestojson.util.exception.ReadInputException;

public final class PropertiesToJsonConverter {
    private final NullToJsonTypeConverter nullToJsonConverter;
    private final TextToJsonNullReferenceResolver textToJsonNullResolver;
    private final TextToEmptyStringResolver textToEmptyStringResolver;
    private final Map<AlgorithmType, JsonTypeResolver> algorithms = new HashMap<AlgorithmType, JsonTypeResolver>();
    private final PrimitiveJsonTypesResolver primitiveResolvers;
    private PropertyKeysOrderResolver propertyKeysOrderResolver = new PropertyKeysOrderResolver();

    public PropertiesToJsonConverter() {
        this(PropertiesToJsonConverterBuilder.TO_OBJECT_RESOLVERS, PropertiesToJsonConverterBuilder.TO_JSON_TYPE_CONVERTERS);
    }

    @Deprecated
    public PropertiesToJsonConverter(PrimitiveJsonTypeResolver ... customPrimitiveResolvers) {
        this(PropertiesToJsonConverter.convertToNewResolvers(customPrimitiveResolvers), PropertiesToJsonConverter.convertToNewConverters(customPrimitiveResolvers));
    }

    private static List<ObjectToJsonTypeConverter> convertToNewConverters(PrimitiveJsonTypeResolver ... customPrimitiveResolvers) {
        PropertiesToJsonConverter.validateTypeResolverOrder(customPrimitiveResolvers);
        return Arrays.stream(customPrimitiveResolvers).map(PrimitiveJsonTypeResolverToNewApiAdapter::new).collect(Collectors.toList());
    }

    private static List<TextToConcreteObjectResolver> convertToNewResolvers(PrimitiveJsonTypeResolver ... customPrimitiveResolvers) {
        return Arrays.stream(customPrimitiveResolvers).map(PrimitiveJsonTypeResolverToNewApiAdapter::new).collect(Collectors.toList());
    }

    public PropertiesToJsonConverter(List<TextToConcreteObjectResolver> toObjectsResolvers, List<ObjectToJsonTypeConverter> toJsonTypeResolvers) {
        this(toObjectsResolvers, toJsonTypeResolvers, NullToJsonTypeConverter.NULL_TO_JSON_RESOLVER, TextToJsonNullReferenceResolver.TEXT_TO_NULL_JSON_RESOLVER, TextToEmptyStringResolver.EMPTY_TEXT_RESOLVER, false);
    }

    public PropertiesToJsonConverter(List<TextToConcreteObjectResolver> toObjectsResolvers, List<ObjectToJsonTypeConverter> toJsonTypeResolvers, NullToJsonTypeConverter nullToJsonConverter, TextToJsonNullReferenceResolver textToJsonNullResolver, TextToEmptyStringResolver textToEmptyStringResolver, Boolean skipNull) {
        this.nullToJsonConverter = nullToJsonConverter;
        this.textToJsonNullResolver = textToJsonNullResolver;
        this.textToEmptyStringResolver = textToEmptyStringResolver;
        PropertiesToJsonConverter.validateTypeResolverOrder(toJsonTypeResolvers);
        this.primitiveResolvers = new PrimitiveJsonTypesResolver(this.buildAllToObjectResolvers(toObjectsResolvers), this.buildAllToJsonResolvers(toJsonTypeResolvers), skipNull, nullToJsonConverter);
        this.algorithms.put(AlgorithmType.OBJECT, new ObjectJsonTypeResolver());
        this.algorithms.put(AlgorithmType.PRIMITIVE, this.primitiveResolvers);
        this.algorithms.put(AlgorithmType.ARRAY, new ArrayJsonTypeResolver());
    }

    private List<TextToConcreteObjectResolver> buildAllToObjectResolvers(List<TextToConcreteObjectResolver> resolvers) {
        ArrayList<TextToConcreteObjectResolver> allResolvers = new ArrayList<TextToConcreteObjectResolver>();
        allResolvers.add(this.textToJsonNullResolver);
        allResolvers.add(this.textToEmptyStringResolver);
        allResolvers.addAll(resolvers);
        allResolvers.add(TextToStringResolver.TO_STRING_RESOLVER);
        return allResolvers;
    }

    private List<ObjectToJsonTypeConverter> buildAllToJsonResolvers(List<ObjectToJsonTypeConverter> toJsonTypeResolvers) {
        ArrayList<ObjectToJsonTypeConverter> mergedToJsonTypeConverters = new ArrayList<ObjectToJsonTypeConverter>(toJsonTypeResolvers);
        mergedToJsonTypeConverters.add(StringToJsonTypeConverter.STRING_TO_JSON_RESOLVER);
        mergedToJsonTypeConverters.add(this.nullToJsonConverter);
        return mergedToJsonTypeConverters;
    }

    public String convertPropertiesFromFileToJson(String pathToFile) throws ReadInputException, ParsePropertiesException {
        return this.convertPropertiesFromFileToJson(new File(pathToFile));
    }

    public String convertPropertiesFromFileToJson(String pathToFile, String ... includeDomainKeys) throws ReadInputException, ParsePropertiesException {
        return this.convertPropertiesFromFileToJson(new File(pathToFile), includeDomainKeys);
    }

    public String convertPropertiesFromFileToJson(File file) throws ReadInputException, ParsePropertiesException {
        try {
            FileInputStream targetStream = new FileInputStream(file);
            return this.convertToJson(targetStream);
        }
        catch (FileNotFoundException e) {
            throw new ReadInputException(e);
        }
    }

    public String convertPropertiesFromFileToJson(File file, String ... includeDomainKeys) throws ReadInputException, ParsePropertiesException {
        try {
            FileInputStream targetStream = new FileInputStream(file);
            return this.convertToJson(targetStream, includeDomainKeys);
        }
        catch (FileNotFoundException e) {
            throw new ReadInputException(e);
        }
    }

    public String convertToJson(InputStream inputStream) throws ReadInputException, ParsePropertiesException {
        return this.convertToJson(this.inputStreamToProperties(inputStream));
    }

    public String convertToJson(InputStream inputStream, String ... includeDomainKeys) throws ReadInputException, ParsePropertiesException {
        return this.convertToJson(this.inputStreamToProperties(inputStream), includeDomainKeys);
    }

    public String convertToJson(Properties properties) throws ParsePropertiesException {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (entry.getKey() instanceof String) continue;
            throw new ParsePropertiesException(String.format("Unsupported property key type: %s for key: %s, Property key needs to be a string type", entry.getKey().getClass(), entry.getKey() == null ? "null" : entry.getKey()));
        }
        return this.convertFromValuesAsObjectMap(PropertiesToJsonConverter.propertiesToMap(properties));
    }

    public String convertToJson(Properties properties, String ... includeDomainKeys) throws ParsePropertiesException {
        return this.convertFromValuesAsObjectMap(PropertiesToJsonConverter.propertiesToMap(properties), includeDomainKeys);
    }

    public String convertToJson(Map<String, String> properties) throws ParsePropertiesException {
        return this.convertFromValuesAsObjectMap(this.stringValueMapToObjectValueMap(properties));
    }

    public String convertToJson(Map<String, String> properties, String ... includeDomainKeys) throws ParsePropertiesException {
        return this.convertFromValuesAsObjectMap(this.stringValueMapToObjectValueMap(properties), includeDomainKeys);
    }

    public String convertFromValuesAsObjectMap(Map<String, Object> properties) throws ParsePropertiesException {
        ObjectJsonType coreObjectJsonType = new ObjectJsonType();
        for (String propertyKey : this.getAllKeysFromProperties(properties)) {
            this.addFieldsToJsonObject(properties, coreObjectJsonType, propertyKey);
        }
        return PropertiesToJsonConverter.prettifyOfJson(coreObjectJsonType.toStringJson());
    }

    private static String prettifyOfJson(String json) {
        Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(json);
        return gson.toJson(je);
    }

    public String convertFromValuesAsObjectMap(Map<String, Object> properties, String ... includeDomainKeys) throws ParsePropertiesException {
        LinkedHashMap<String, Object> filteredProperties = new LinkedHashMap<String, Object>();
        for (String key : properties.keySet()) {
            for (String requiredKey : includeDomainKeys) {
                PropertiesToJsonConverter.checkKey(properties, filteredProperties, key, requiredKey);
            }
        }
        return this.convertFromValuesAsObjectMap(filteredProperties);
    }

    public void setPropertyKeysOrderResolver(PropertyKeysOrderResolver propertyKeysOrderResolver) {
        Objects.requireNonNull(propertyKeysOrderResolver);
        this.propertyKeysOrderResolver = propertyKeysOrderResolver;
    }

    private static void checkKey(Map<String, Object> properties, Map<String, Object> filteredProperties, String key, String requiredKey) {
        if (key.equals(requiredKey) || key.startsWith(requiredKey) && PropertiesToJsonConverter.keyIsCompatibleWithRequiredKey(requiredKey, key)) {
            filteredProperties.put(key, properties.get(key));
        }
    }

    private static boolean keyIsCompatibleWithRequiredKey(String requiredKey, String key) {
        String testedChar = key.substring(requiredKey.length(), requiredKey.length() + 1);
        return testedChar.equals("[") || testedChar.equals(".");
    }

    private Properties inputStreamToProperties(InputStream inputStream) throws ReadInputException {
        PropertiesWithInsertOrder propertiesWithConvertedValues = new PropertiesWithInsertOrder();
        PropertiesWithInsertOrder properties = new PropertiesWithInsertOrder();
        try {
            properties.load(inputStream);
            for (String property : this.getAllKeysFromProperties(PropertiesToJsonConverter.propertiesToMap(properties))) {
                Object object = this.primitiveResolvers.getResolvedObject((String)properties.get(property), property);
                ((Properties)propertiesWithConvertedValues).put(property, object);
            }
        }
        catch (IOException e) {
            throw new ReadInputException(e);
        }
        return propertiesWithConvertedValues;
    }

    private void addFieldsToJsonObject(Map<String, Object> properties, ObjectJsonType coreObjectJsonType, String propertyKey) {
        PathMetadata rootPathMetaData = PathMetadataBuilder.createRootPathMetaData(propertyKey);
        new JsonObjectsTraverseResolver(this.algorithms, properties, propertyKey, rootPathMetaData, coreObjectJsonType).initializeFieldsInJson();
    }

    private List<String> getAllKeysFromProperties(Map<String, ?> properties) {
        return this.propertyKeysOrderResolver.getKeysInExpectedOrder(properties);
    }

    private static Map<String, Object> propertiesToMap(Properties properties) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Object key : properties.keySet()) {
            map.put(key.toString(), properties.get(key));
        }
        return map;
    }

    private Map<String, Object> stringValueMapToObjectValueMap(Map<String, String> properties) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String property : this.getAllKeysFromProperties(properties)) {
            Object object = this.primitiveResolvers.getResolvedObject(properties.get(property), property);
            map.put(property, object);
        }
        return map;
    }

    private static void validateTypeResolverOrder(PrimitiveJsonTypeResolver ... primitiveResolvers) {
        PrimitiveJsonTypeResolver lastResolver;
        List<PrimitiveJsonTypeResolver> resolvers = Arrays.asList(primitiveResolvers);
        boolean containStringResolverType = false;
        for (PrimitiveJsonTypeResolver resolver : resolvers) {
            if (!resolver.getClass().equals(StringJsonTypeResolver.class)) continue;
            containStringResolverType = true;
        }
        if (containStringResolverType && !(lastResolver = resolvers.get(resolvers.size() - 1)).getClass().equals(StringJsonTypeResolver.class)) {
            throw new ParsePropertiesException(ParsePropertiesException.STRING_RESOLVER_AS_NOT_LAST);
        }
    }

    private static void validateTypeResolverOrder(List<ObjectToJsonTypeConverter> resolvers) {
        ObjectToJsonTypeConverter lastResolver;
        boolean containStringResolverType = false;
        for (ObjectToJsonTypeConverter resolver : resolvers) {
            if (!resolver.getClass().equals(StringToJsonTypeConverter.class)) continue;
            containStringResolverType = true;
        }
        if (containStringResolverType && !(lastResolver = resolvers.get(resolvers.size() - 1)).getClass().equals(StringToJsonTypeConverter.class)) {
            throw new ParsePropertiesException(ParsePropertiesException.STRING__TO_JSON_RESOLVER_AS_NOT_LAST);
        }
    }
}

