/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.propertiestojson.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import pl.jalokim.propertiestojson.resolvers.primitives.object.AbstractObjectToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.object.BooleanToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.object.CharacterToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.object.ElementsToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.object.NullToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.object.NumberToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.object.ObjectToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.object.SuperObjectToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToBooleanResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToCharacterResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToConcreteObjectResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToElementsResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToEmptyStringResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToJsonNullReferenceResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToNumberResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToObjectResolver;
import pl.jalokim.propertiestojson.util.PropertiesToJsonConverter;

public class PropertiesToJsonConverterBuilder {
    static final List<TextToConcreteObjectResolver> TO_OBJECT_RESOLVERS = PropertiesToJsonConverterBuilder.defaultResolvers();
    static final List<ObjectToJsonTypeConverter> TO_JSON_TYPE_CONVERTERS = PropertiesToJsonConverterBuilder.defaultConverters();
    private final List<TextToConcreteObjectResolver> resolvers = new ArrayList<TextToConcreteObjectResolver>();
    private final List<ObjectToJsonTypeConverter> converters = new ArrayList<ObjectToJsonTypeConverter>();
    private NullToJsonTypeConverter nullToJsonConverter = NullToJsonTypeConverter.NULL_TO_JSON_RESOLVER;
    private TextToJsonNullReferenceResolver textToJsonNullResolver = TextToJsonNullReferenceResolver.TEXT_TO_NULL_JSON_RESOLVER;
    private TextToEmptyStringResolver textToEmptyStringResolver = TextToEmptyStringResolver.EMPTY_TEXT_RESOLVER;
    private boolean skipNul = false;
    private boolean onlyCustomConverters = false;
    private boolean onlyCustomResolvers = false;

    static List<TextToConcreteObjectResolver> defaultResolvers() {
        ArrayList toObjectResolvers = new ArrayList();
        toObjectResolvers.add(new TextToElementsResolver());
        toObjectResolvers.add(new TextToObjectResolver());
        toObjectResolvers.add(new TextToNumberResolver());
        toObjectResolvers.add(new TextToCharacterResolver());
        toObjectResolvers.add(new TextToBooleanResolver());
        return Collections.unmodifiableList(toObjectResolvers);
    }

    static List<ObjectToJsonTypeConverter> defaultConverters() {
        ArrayList<AbstractObjectToJsonTypeConverter> toJsonTypeConverters = new ArrayList<AbstractObjectToJsonTypeConverter>();
        toJsonTypeConverters.add(new ElementsToJsonTypeConverter());
        toJsonTypeConverters.add(new SuperObjectToJsonTypeConverter());
        toJsonTypeConverters.add(new NumberToJsonTypeConverter());
        toJsonTypeConverters.add(new CharacterToJsonTypeConverter());
        toJsonTypeConverters.add(new BooleanToJsonTypeConverter());
        return Collections.unmodifiableList(toJsonTypeConverters);
    }

    public static PropertiesToJsonConverterBuilder builder() {
        return new PropertiesToJsonConverterBuilder();
    }

    public PropertiesToJsonConverterBuilder onlyCustomTextToObjectResolvers(TextToConcreteObjectResolver ... resolvers) {
        this.onlyCustomResolvers = true;
        this.resolvers.addAll(Arrays.asList(resolvers));
        return this;
    }

    public PropertiesToJsonConverterBuilder defaultAndCustomTextToObjectResolvers(TextToConcreteObjectResolver ... resolvers) {
        this.onlyCustomResolvers = false;
        this.resolvers.addAll(Arrays.asList(resolvers));
        return this;
    }

    public PropertiesToJsonConverterBuilder onlyCustomObjectToJsonTypeConverters(ObjectToJsonTypeConverter ... converters) {
        this.onlyCustomConverters = true;
        this.converters.addAll(Arrays.asList(converters));
        return this;
    }

    public PropertiesToJsonConverterBuilder defaultAndCustomObjectToJsonTypeConverters(ObjectToJsonTypeConverter ... converters) {
        this.onlyCustomConverters = false;
        this.converters.addAll(Arrays.asList(converters));
        return this;
    }

    public PropertiesToJsonConverterBuilder overrideNullToJsonConverter(NullToJsonTypeConverter nullToJsonConverter) {
        this.nullToJsonConverter = nullToJsonConverter;
        return this;
    }

    public PropertiesToJsonConverterBuilder overrideTextToJsonNullResolver(TextToJsonNullReferenceResolver textToJsonNullResolver) {
        this.textToJsonNullResolver = textToJsonNullResolver;
        return this;
    }

    public PropertiesToJsonConverterBuilder overrideTextToEmptyStringResolver(TextToEmptyStringResolver textToEmptyStringResolver) {
        this.textToEmptyStringResolver = textToEmptyStringResolver;
        return this;
    }

    public PropertiesToJsonConverterBuilder skipNulls() {
        this.skipNul = true;
        return this;
    }

    public PropertiesToJsonConverter build() {
        ArrayList<ObjectToJsonTypeConverter> resultConverters = new ArrayList<ObjectToJsonTypeConverter>();
        if (this.onlyCustomConverters) {
            resultConverters.addAll(this.converters);
        } else {
            resultConverters.addAll(this.converters);
            resultConverters.addAll(TO_JSON_TYPE_CONVERTERS);
        }
        ArrayList<TextToConcreteObjectResolver> resultResolvers = new ArrayList<TextToConcreteObjectResolver>();
        if (this.onlyCustomResolvers) {
            resultResolvers.addAll(this.resolvers);
        } else {
            resultResolvers.addAll(this.resolvers);
            resultResolvers.addAll(TO_OBJECT_RESOLVERS);
        }
        return new PropertiesToJsonConverter(resultResolvers, resultConverters, this.nullToJsonConverter, this.textToJsonNullResolver, this.textToEmptyStringResolver, this.skipNul);
    }
}

