/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.propertiestojson.resolvers;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import pl.jalokim.propertiestojson.JsonObjectFieldsValidator;
import pl.jalokim.propertiestojson.object.AbstractJsonType;
import pl.jalokim.propertiestojson.object.ArrayJsonType;
import pl.jalokim.propertiestojson.object.JsonNullReferenceType;
import pl.jalokim.propertiestojson.object.ObjectJsonType;
import pl.jalokim.propertiestojson.object.SkipJsonField;
import pl.jalokim.propertiestojson.path.PathMetadata;
import pl.jalokim.propertiestojson.resolvers.JsonTypeResolver;
import pl.jalokim.propertiestojson.resolvers.hierarchy.JsonTypeResolversHierarchyResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.object.NullToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.object.ObjectToJsonTypeConverter;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToConcreteObjectResolver;
import pl.jalokim.propertiestojson.util.exception.CannotOverrideFieldException;

public class PrimitiveJsonTypesResolver
extends JsonTypeResolver {
    private final List<TextToConcreteObjectResolver<?>> toObjectsResolvers;
    private final JsonTypeResolversHierarchyResolver resolversHierarchyResolver;
    private final Boolean skipNulls;
    private final NullToJsonTypeConverter nullToJsonTypeConverter;

    public PrimitiveJsonTypesResolver(List<TextToConcreteObjectResolver<?>> toObjectsResolvers, List<ObjectToJsonTypeConverter<?>> toJsonResolvers, Boolean skipNulls, NullToJsonTypeConverter nullToJsonTypeConverter) {
        this.toObjectsResolvers = ImmutableList.copyOf(toObjectsResolvers);
        this.resolversHierarchyResolver = new JsonTypeResolversHierarchyResolver(toJsonResolvers);
        this.skipNulls = skipNulls;
        this.nullToJsonTypeConverter = nullToJsonTypeConverter;
    }

    @Override
    public ObjectJsonType traverse(PathMetadata currentPathMetaData) {
        this.addPrimitiveFieldWhenIsValid(currentPathMetaData);
        return null;
    }

    private void addPrimitiveFieldWhenIsValid(PathMetadata currentPathMetaData) {
        JsonObjectFieldsValidator.checkThatFieldCanBeSet(this.currentObjectJsonType, currentPathMetaData, this.propertyKey);
        this.addPrimitiveFieldToCurrentJsonObject(currentPathMetaData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addPrimitiveFieldToCurrentJsonObject(PathMetadata currentPathMetaData) {
        String field = currentPathMetaData.getFieldName();
        if (currentPathMetaData.isArrayField()) {
            this.addFieldToArray(currentPathMetaData);
            return;
        } else if (this.currentObjectJsonType.containsField(field) && JsonObjectFieldsValidator.isArrayJson(this.currentObjectJsonType.getField(field))) {
            AbstractJsonType abstractJsonType = currentPathMetaData.getJsonValue();
            ArrayJsonType currentArrayInObject = this.currentObjectJsonType.getJsonArray(field);
            if (!JsonObjectFieldsValidator.isArrayJson(abstractJsonType)) throw new CannotOverrideFieldException(currentPathMetaData.getCurrentFullPath(), currentArrayInObject, this.propertyKey);
            ArrayJsonType newArray = (ArrayJsonType)abstractJsonType;
            List<AbstractJsonType> abstractJsonTypes = newArray.convertToListWithoutRealNull();
            for (int i = 0; i < abstractJsonTypes.size(); ++i) {
                currentArrayInObject.addElement(i, abstractJsonTypes.get(i), currentPathMetaData);
            }
            return;
        } else {
            this.currentObjectJsonType.addField(field, currentPathMetaData.getJsonValue(), currentPathMetaData);
        }
    }

    public Object getResolvedObject(String propertyValue, String propertyKey) {
        Optional<Object> objectOptional = Optional.empty();
        for (TextToConcreteObjectResolver<?> primitiveResolver : this.toObjectsResolvers) {
            if (objectOptional.isPresent()) continue;
            objectOptional = primitiveResolver.returnConvertedValueForClearedText(this, propertyValue, propertyKey);
        }
        return objectOptional.orElse(null);
    }

    public AbstractJsonType resolvePrimitiveTypeAndReturn(Object propertyValue, String propertyKey) {
        AbstractJsonType result = propertyValue == null ? this.nullToJsonTypeConverter.convertToJsonTypeOrEmpty(this, JsonNullReferenceType.NULL_OBJECT, propertyKey).get() : this.resolversHierarchyResolver.returnConcreteJsonTypeObject(this, propertyValue, propertyKey);
        if (Boolean.TRUE.equals(this.skipNulls) && result instanceof JsonNullReferenceType) {
            result = SkipJsonField.SKIP_JSON_FIELD;
        }
        return result;
    }

    protected void addFieldToArray(PathMetadata currentPathMetaData) {
        if (this.arrayWithGivenFieldNameExist(currentPathMetaData.getFieldName())) {
            this.fetchArrayAndAddElement(currentPathMetaData);
        } else {
            this.createArrayAndAddElement(currentPathMetaData);
        }
    }

    private boolean arrayWithGivenFieldNameExist(String field) {
        return this.currentObjectJsonType.containsField(field);
    }

    private void createArrayAndAddElement(PathMetadata currentPathMetaData) {
        ArrayJsonType arrayJsonTypeObject = new ArrayJsonType();
        this.addElementToArray(currentPathMetaData, arrayJsonTypeObject);
        this.currentObjectJsonType.addField(currentPathMetaData.getFieldName(), arrayJsonTypeObject, currentPathMetaData);
    }

    private void fetchArrayAndAddElement(PathMetadata currentPathMetaData) {
        ArrayJsonType arrayJsonType = this.getArrayJsonWhenIsValid(currentPathMetaData);
        this.addElementToArray(currentPathMetaData, arrayJsonType);
    }

    private void addElementToArray(PathMetadata currentPathMetaData, ArrayJsonType arrayJsonTypeObject) {
        arrayJsonTypeObject.addElement(currentPathMetaData.getPropertyArrayHelper(), currentPathMetaData.getJsonValue(), currentPathMetaData);
    }
}

