/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.propertiestojson.resolvers.primitives.string;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import pl.jalokim.propertiestojson.resolvers.PrimitiveJsonTypesResolver;
import pl.jalokim.propertiestojson.resolvers.primitives.string.TextToConcreteObjectResolver;

public class TextToNumberResolver
implements TextToConcreteObjectResolver<Number> {
    public static Number convertToNumber(String propertyValue) {
        Number number = TextToNumberResolver.convertToNumberFromText(propertyValue);
        if (number != null && number.toString().equals(propertyValue)) {
            return number;
        }
        return null;
    }

    private static Number convertToNumberFromText(String propertyValue) {
        try {
            return TextToNumberResolver.getIntegerNumber(propertyValue);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return TextToNumberResolver.getDoubleNumber(propertyValue);
            }
            catch (NumberFormatException numberFormatException2) {
                return null;
            }
        }
    }

    private static BigInteger getIntegerNumber(String toParse) {
        return new BigInteger(toParse);
    }

    private static BigDecimal getDoubleNumber(String toParse) {
        return new BigDecimal(toParse);
    }

    @Override
    public Optional<Number> returnObjectWhenCanBeResolved(PrimitiveJsonTypesResolver primitiveJsonTypesResolver, String propertyValue, String propertyKey) {
        return Optional.ofNullable(TextToNumberResolver.convertToNumber(propertyValue));
    }
}

