/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.iteration;

import pl.jalokim.utils.iteration.ExceptionableConsumer;
import pl.jalokim.utils.iteration.ExceptionableRunnable;
import pl.jalokim.utils.iteration.IterationException;

public final class IterationUtils {
    private IterationUtils() {
    }

    public static void repeatNTimes(int nTimes, ExceptionableRunnable runnable) {
        IterationUtils.repeatNTimes(nTimes, (int index) -> runnable.invoke());
    }

    public static void repeatNTimes(int nTimes, ExceptionableConsumer consumer) {
        for (int i = 0; i < nTimes; ++i) {
            try {
                consumer.consume(i);
                continue;
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception throwable) {
                throw new IterationException(throwable);
            }
        }
    }
}

