/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import pl.jalokim.utils.collection.Elements;
import pl.jalokim.utils.reflection.AmbiguousExecutableCallException;
import pl.jalokim.utils.reflection.ClassParentsInfo;
import pl.jalokim.utils.reflection.ClassParentsParser;
import pl.jalokim.utils.reflection.ExecutableMetadata;
import pl.jalokim.utils.reflection.TypeMetadata;
import pl.jalokim.utils.reflection.TypeWrapperBuilder;

public final class ExecutableByArgsFinder {
    public static Method findMethod(Class<?> targetClass, String methodName, Class<?> ... argClasses) {
        ArrayList foundMethods = new ArrayList();
        for (Class<?> currentClass = targetClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            foundMethods.addAll(((Elements)((Elements)Elements.elements(currentClass.getDeclaredMethods()).filter(method -> method.getName().equals(methodName))).filter(method -> method.getParameterTypes().length == argClasses.length)).asList());
        }
        return (Method)ExecutableByArgsFinder.findExecutable(targetClass, foundMethods, argClasses);
    }

    public static Constructor<?> findConstructor(Class<?> targetClass, Class<?> ... argClasses) {
        List foundConstructors = ((Elements)Elements.elements(targetClass.getDeclaredConstructors()).filter(constructor -> constructor.getParameterTypes().length == argClasses.length)).asList();
        return (Constructor)ExecutableByArgsFinder.findExecutable(targetClass, foundConstructors, argClasses);
    }

    public static <T extends Executable> T findExecutable(Class<?> targetClass, List<? extends Executable> foundExecutables, Class<?> ... argClasses) {
        Map<Integer, List<Executable>> executablesByLengthOfPath = ExecutableByArgsFinder.matchExecutableByArgTypes(targetClass, foundExecutables, argClasses);
        if (executablesByLengthOfPath.isEmpty()) {
            return null;
        }
        Integer shortestPath = Elements.elements(executablesByLengthOfPath.keySet()).min(Integer::compareTo).get();
        List<Executable> executables = executablesByLengthOfPath.get(shortestPath);
        if (executables.size() != 1) {
            throw new AmbiguousExecutableCallException(executables);
        }
        return (T)executables.get(0);
    }

    private static Map<Integer, List<Executable>> matchExecutableByArgTypes(Class<?> targetClass, List<? extends Executable> foundExecutables, Class<?> ... argClasses) {
        HashMap<Integer, List<Executable>> executablesByLengthOfPath = new HashMap<Integer, List<Executable>>();
        TypeMetadata typeMetadata = TypeWrapperBuilder.buildFromClass(targetClass);
        block0: for (Executable executable : foundExecutables) {
            int typeDifferenceLevel = 0;
            for (int argIndex = 0; argIndex < executable.getParameterTypes().length; ++argIndex) {
                ExecutableMetadata<?> metaForExecutable = ExecutableByArgsFinder.getExecutableMetadataFor(typeMetadata, executable);
                Class<?> classFromExecutableArg = metaForExecutable.getParameters().get(argIndex).getTypeOfParameter().getRawType();
                ClassParentsInfo parentsInfo = ClassParentsParser.parentsInfoFromClass(argClasses[argIndex]);
                if (!parentsInfo.canBeCastTo(classFromExecutableArg)) continue block0;
                typeDifferenceLevel += parentsInfo.getHierarchyDiffLength(classFromExecutableArg).intValue();
            }
            ExecutableByArgsFinder.putFoundExecutableByScore(executablesByLengthOfPath, executable, typeDifferenceLevel);
        }
        return executablesByLengthOfPath;
    }

    private static ExecutableMetadata<?> getExecutableMetadataFor(TypeMetadata typeMetadata, Executable executable) {
        if (executable instanceof Method) {
            return typeMetadata.getMetaForMethod((Method)executable);
        }
        if (executable instanceof Constructor) {
            return typeMetadata.getMetaForConstructor((Constructor)executable);
        }
        throw new IllegalArgumentException("Executable instance not Method or not Constructor type, was given type: " + executable.getDeclaringClass());
    }

    private static void putFoundExecutableByScore(Map<Integer, List<Executable>> executableByScore, Executable foundExecutable, int matchScore) {
        List<Executable> executables = executableByScore.get(matchScore);
        if (executables == null) {
            ArrayList<Executable> newExecutables = new ArrayList<Executable>();
            newExecutables.add(foundExecutable);
            executableByScore.put(matchScore, newExecutables);
        } else {
            executables.add(foundExecutable);
        }
    }

    @Generated
    private ExecutableByArgsFinder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

