/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import pl.jalokim.utils.collection.CollectionUtils;
import pl.jalokim.utils.collection.Elements;
import pl.jalokim.utils.reflection.ConstructorMetadata;
import pl.jalokim.utils.reflection.MetadataReflectionUtils;
import pl.jalokim.utils.reflection.MethodMetadata;
import pl.jalokim.utils.reflection.ParameterMetadata;
import pl.jalokim.utils.reflection.ReflectionOperationException;
import pl.jalokim.utils.reflection.TypeWrapperBuilder;
import pl.jalokim.utils.string.StringUtils;

public final class TypeMetadata {
    private static final Map<String, TypeMetadata> RESOLVED_GENERIC_TYPES = new HashMap<String, TypeMetadata>();
    static final TypeMetadata NATIVE_OBJECT_META = TypeWrapperBuilder.buildFromClass(Object.class);
    private static final String ARRAY_MARK = "[]";
    private final List<TypeMetadata> genericTypes;
    private final Class<?> rawType;
    private final Map<String, TypeMetadata> genericTypesByRawLabel;
    private final TypeMetadata parentTypeMetadata;
    private final List<TypeMetadata> parentInterfaces;

    static TypeMetadata newTypeMetadata(Class<?> rawType, List<TypeMetadata> genericTypes) {
        String rawTypeAndMetadataToText = TypeMetadata.rawTypeAndMetadataToText(rawType, genericTypes);
        if (RESOLVED_GENERIC_TYPES.get(rawTypeAndMetadataToText) != null) {
            return RESOLVED_GENERIC_TYPES.get(rawTypeAndMetadataToText);
        }
        return new TypeMetadata(rawType, genericTypes);
    }

    private TypeMetadata(Class<?> rawType, List<TypeMetadata> genericTypes) {
        ArrayList<TypeMetadata> tempGenerics = CollectionUtils.isEmpty(genericTypes) ? new ArrayList<TypeMetadata>() : genericTypes;
        this.rawType = rawType;
        RESOLVED_GENERIC_TYPES.put(TypeMetadata.rawTypeAndMetadataToText(rawType, genericTypes), this);
        List<Type> parametrizedTypesForClass = MetadataReflectionUtils.getParametrizedRawTypes(rawType);
        if (CollectionUtils.isEmpty(parametrizedTypesForClass) && CollectionUtils.isNotEmpty(tempGenerics) && !rawType.isArray()) {
            AtomicInteger index2 = new AtomicInteger();
            throw new ReflectionOperationException(String.format("raw class: %s doesn't have any parametrized types, but tried put generic types:%n%s", rawType.getCanonicalName(), StringUtils.concatElementsAsLines(tempGenerics, text -> StringUtils.concatObjects(index2.getAndIncrement(), ".", " ", text))));
        }
        ConcurrentHashMap tempMap = new ConcurrentHashMap();
        Elements.elements(parametrizedTypesForClass).forEach((index, type) -> {
            if (tempGenerics.size() == index.intValue()) {
                TypeWrapperBuilder.buildFromClass(Object.class);
                tempGenerics.add((int)index, NATIVE_OBJECT_META);
                tempMap.put(type.getTypeName(), NATIVE_OBJECT_META);
            } else {
                tempMap.put(type.getTypeName(), tempGenerics.get((int)index));
            }
        });
        this.genericTypes = Collections.unmodifiableList(tempGenerics);
        this.genericTypesByRawLabel = Collections.unmodifiableMap(tempMap);
        this.parentTypeMetadata = this.buildParentMetadata(this, this.genericTypesByRawLabel, rawType.getSuperclass(), rawType.getGenericSuperclass());
        this.parentInterfaces = this.buildParentInterfacesMetadata(this, this.genericTypesByRawLabel);
    }

    private List<TypeMetadata> buildParentInterfacesMetadata(TypeMetadata childMetadata, Map<String, TypeMetadata> childGenericTypesByRawLabel) {
        return Elements.elements(this.rawType.getInterfaces()).mapWithIndex((index, interfaceClass) -> this.buildParentMetadata(childMetadata, childGenericTypesByRawLabel, (Class<?>)interfaceClass, this.rawType.getGenericInterfaces()[index])).asList();
    }

    private TypeMetadata buildParentMetadata(TypeMetadata childMetadata, Map<String, TypeMetadata> childGenericTypesByRawLabel, Class<?> parentClass, Type genericSuperclass) {
        if (parentClass == null) {
            return null;
        }
        if (parentClass == Object.class || childMetadata.getRawType().isEnum() || childMetadata.isArrayType()) {
            return null;
        }
        if (genericSuperclass.equals(parentClass)) {
            return TypeMetadata.newTypeMetadata(parentClass, null);
        }
        List<TypeMetadata> types = ((Elements)Elements.elements(((ParameterizedType)genericSuperclass).getActualTypeArguments()).map(type -> this.mapFromType((Type)type, childGenericTypesByRawLabel))).asList();
        return TypeMetadata.newTypeMetadata(parentClass, types);
    }

    private TypeMetadata mapFromType(Type type, Map<String, TypeMetadata> childGenericTypesByRawLabel) {
        if (type instanceof Class) {
            return TypeWrapperBuilder.buildFromClass((Class)type);
        }
        TypeMetadata typeMetadata = childGenericTypesByRawLabel.get(type.getTypeName());
        if (typeMetadata == null) {
            typeMetadata = TypeWrapperBuilder.buildFromType(type, this.rawType, this);
        }
        return typeMetadata;
    }

    public boolean hasGenericTypes() {
        return CollectionUtils.isNotEmpty(this.genericTypes);
    }

    public String getCanonicalName() {
        return this.rawType.getCanonicalName();
    }

    public TypeMetadata getTypeMetadataByGenericLabel(Class<?> fieldOwner, String typeName) {
        for (TypeMetadata currentMeta = this; currentMeta != null; currentMeta = currentMeta.getParentTypeMetadata()) {
            TypeMetadata typeMetadataForGenericLabel;
            if (!currentMeta.getRawType().equals(fieldOwner) || (typeMetadataForGenericLabel = currentMeta.getByGenericLabel(typeName)) == null) continue;
            return typeMetadataForGenericLabel;
        }
        throw new ReflectionOperationException(String.format("Cannot find raw type: '%s' for class: '%s' in current context: %s ", typeName, fieldOwner.getCanonicalName(), this.toString()));
    }

    public TypeMetadata getByGenericLabel(String genericLabel) {
        return this.genericTypesByRawLabel.get(genericLabel);
    }

    public boolean isEnumType() {
        return this.getRawType().isEnum();
    }

    public boolean isArrayType() {
        return this.getRawType().isArray();
    }

    public boolean isMapType() {
        return MetadataReflectionUtils.isMapType(this.getRawType());
    }

    public boolean isHavingElementsType() {
        return this.isArrayType() || MetadataReflectionUtils.isHavingElementsType(this.getRawType());
    }

    public boolean isSimpleType() {
        return MetadataReflectionUtils.isSimpleType(this.getRawType());
    }

    public boolean hasParent() {
        return this.parentTypeMetadata != null;
    }

    public boolean hasParentInterfaces() {
        return CollectionUtils.isNotEmpty(this.parentInterfaces);
    }

    public TypeMetadata getMetaForField(String fieldName) {
        Field field = MetadataReflectionUtils.getField(this.rawType, fieldName);
        return this.getMetaForField(field);
    }

    public TypeMetadata getMetaForField(Field field) {
        if (field.getGenericType() instanceof Class) {
            return TypeWrapperBuilder.buildFromField(field);
        }
        return TypeWrapperBuilder.buildFromType(field.getGenericType(), field.getDeclaringClass(), this);
    }

    public MethodMetadata getMetaForMethod(Method method) {
        return MethodMetadata.builder().annotations(Elements.elements(method.getDeclaredAnnotations()).asList()).method(method).name(method.getName()).returnType(this.getMetaForType(method.getGenericReturnType(), method.getDeclaringClass())).parameters(this.createParametersMetadata(method)).build();
    }

    public MethodMetadata getMetaForMethod(String methodName, Class<?> ... argumentTypes) {
        Method method = MetadataReflectionUtils.getMethod(this.getRawType(), methodName, argumentTypes);
        return this.getMetaForMethod(method);
    }

    public MethodMetadata getMetaForMethod(String methodName, List<Class<?>> argumentTypes) {
        Method method = MetadataReflectionUtils.getMethod(this.getRawType(), methodName, argumentTypes);
        return this.getMetaForMethod(method);
    }

    public MethodMetadata getMetaForMethodByArgsToInvoke(String methodName, List<Object> args) {
        List<Class<?>> argClasses = CollectionUtils.mapToList(args, Object::getClass);
        Method method = MetadataReflectionUtils.getMethod(this.getRawType(), methodName, argClasses);
        return this.getMetaForMethod(method);
    }

    public MethodMetadata getMetaForMethodByArgsToInvoke(String methodName, Object ... args) {
        List<Class> argClasses = CollectionUtils.mapToList(Object::getClass, args);
        Method method = MetadataReflectionUtils.getMethod(this.getRawType(), methodName, argClasses.toArray(new Class[0]));
        return this.getMetaForMethod(method);
    }

    public ConstructorMetadata getMetaForConstructor(Constructor<?> constructor) {
        return ConstructorMetadata.builder().annotations(Elements.elements(constructor.getDeclaredAnnotations()).asList()).constructor(constructor).parameters(this.createParametersMetadata(constructor)).build();
    }

    public ConstructorMetadata getMetaForConstructor(Class<?> ... argumentTypes) {
        Constructor<?> constructor = MetadataReflectionUtils.getConstructor(this.getRawType(), argumentTypes);
        return this.getMetaForConstructor(constructor);
    }

    public ConstructorMetadata getMetaForConstructor(List<? extends Class<?>> argumentTypes) {
        return this.getMetaForConstructor(argumentTypes.toArray(new Class[0]));
    }

    public ConstructorMetadata getMetaForConstructorByArgsToInvoke(Object ... args) {
        return this.getMetaForConstructorByArgsToInvoke(Elements.elements(args).asList());
    }

    public ConstructorMetadata getMetaForConstructorByArgsToInvoke(List<Object> args) {
        List argumentTypes = ((Elements)Elements.elements(args).map(Object::getClass)).asList();
        return this.getMetaForConstructor(argumentTypes);
    }

    private List<ParameterMetadata> createParametersMetadata(Executable executable) {
        ArrayList<ParameterMetadata> parameterMetadata = new ArrayList<ParameterMetadata>();
        for (int parameterIndex = 0; parameterIndex < executable.getGenericParameterTypes().length; ++parameterIndex) {
            Annotation[] parameterAnnotation = executable.getParameterAnnotations()[parameterIndex];
            Parameter parameter = executable.getParameters()[parameterIndex];
            parameterMetadata.add(ParameterMetadata.builder().annotations(Elements.elements(parameterAnnotation).asList()).name(parameter.getName()).parameter(parameter).typeOfParameter(this.getMetaForType(executable.getGenericParameterTypes()[parameterIndex], executable.getDeclaringClass())).build());
        }
        return parameterMetadata;
    }

    public TypeMetadata getGenericType(int index) {
        if (this.hasGenericTypes() && this.getGenericTypes().size() - 1 >= index) {
            return this.genericTypes.get(index);
        }
        throw new ReflectionOperationException("Cannot find generic type at index: " + index);
    }

    public String toString() {
        if (this.isArrayType()) {
            return StringUtils.concat(StringUtils.concatElements(this.getGenericTypes()), ARRAY_MARK);
        }
        String additionalTypeMetadata = "";
        if (this.hasGenericTypes()) {
            additionalTypeMetadata = StringUtils.concatElements("<", this.getGenericTypes(), TypeMetadata::toString, ",", ">");
        }
        if (this.hasParent()) {
            additionalTypeMetadata = additionalTypeMetadata + " extends " + this.parentTypeMetadata.toString();
        }
        String classType = this.rawType.getSimpleName();
        return StringUtils.isNotBlank(additionalTypeMetadata) ? String.format("%s%s", classType, additionalTypeMetadata) : classType;
    }

    private static String rawTypeAndMetadataToText(Class<?> rawType, List<TypeMetadata> genericTypes) {
        String genericsInfo = Elements.elements(genericTypes).mapWithIndex((index, genericType) -> String.format("%s=%s", index, genericType.toString())).concatWithNewLines();
        return Elements.elements(rawType.getCanonicalName(), genericsInfo).concatWithNewLines();
    }

    private TypeMetadata getMetaForType(Type type, Class<?> typeIsFromClass) {
        if (type instanceof Class) {
            return TypeWrapperBuilder.buildFromClass((Class)type);
        }
        return TypeWrapperBuilder.buildFromType(type, typeIsFromClass, this);
    }

    @Generated
    public List<TypeMetadata> getGenericTypes() {
        return this.genericTypes;
    }

    @Generated
    public Class<?> getRawType() {
        return this.rawType;
    }

    @Generated
    public Map<String, TypeMetadata> getGenericTypesByRawLabel() {
        return this.genericTypesByRawLabel;
    }

    @Generated
    public TypeMetadata getParentTypeMetadata() {
        return this.parentTypeMetadata;
    }

    @Generated
    public List<TypeMetadata> getParentInterfaces() {
        return this.parentInterfaces;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeMetadata)) {
            return false;
        }
        TypeMetadata other = (TypeMetadata)o;
        List<TypeMetadata> this$genericTypes = this.getGenericTypes();
        List<TypeMetadata> other$genericTypes = other.getGenericTypes();
        if (this$genericTypes == null ? other$genericTypes != null : !((Object)this$genericTypes).equals(other$genericTypes)) {
            return false;
        }
        Class<?> this$rawType = this.getRawType();
        Class<?> other$rawType = other.getRawType();
        if (this$rawType == null ? other$rawType != null : !this$rawType.equals(other$rawType)) {
            return false;
        }
        Map<String, TypeMetadata> this$genericTypesByRawLabel = this.getGenericTypesByRawLabel();
        Map<String, TypeMetadata> other$genericTypesByRawLabel = other.getGenericTypesByRawLabel();
        if (this$genericTypesByRawLabel == null ? other$genericTypesByRawLabel != null : !((Object)this$genericTypesByRawLabel).equals(other$genericTypesByRawLabel)) {
            return false;
        }
        TypeMetadata this$parentTypeMetadata = this.getParentTypeMetadata();
        TypeMetadata other$parentTypeMetadata = other.getParentTypeMetadata();
        if (this$parentTypeMetadata == null ? other$parentTypeMetadata != null : !((Object)this$parentTypeMetadata).equals(other$parentTypeMetadata)) {
            return false;
        }
        List<TypeMetadata> this$parentInterfaces = this.getParentInterfaces();
        List<TypeMetadata> other$parentInterfaces = other.getParentInterfaces();
        return !(this$parentInterfaces == null ? other$parentInterfaces != null : !((Object)this$parentInterfaces).equals(other$parentInterfaces));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<TypeMetadata> $genericTypes = this.getGenericTypes();
        result = result * 59 + ($genericTypes == null ? 43 : ((Object)$genericTypes).hashCode());
        Class<?> $rawType = this.getRawType();
        result = result * 59 + ($rawType == null ? 43 : $rawType.hashCode());
        Map<String, TypeMetadata> $genericTypesByRawLabel = this.getGenericTypesByRawLabel();
        result = result * 59 + ($genericTypesByRawLabel == null ? 43 : ((Object)$genericTypesByRawLabel).hashCode());
        TypeMetadata $parentTypeMetadata = this.getParentTypeMetadata();
        result = result * 59 + ($parentTypeMetadata == null ? 43 : ((Object)$parentTypeMetadata).hashCode());
        List<TypeMetadata> $parentInterfaces = this.getParentInterfaces();
        result = result * 59 + ($parentInterfaces == null ? 43 : ((Object)$parentInterfaces).hashCode());
        return result;
    }
}

